var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Aquaman");
    hero.setTier(7);
 
    hero.setChestplate("Suit");
    
    hero.addPowers("eden:atlantean_royalty");
    hero.addAttribute("BASE_SPEED_LEVELS", 2.0, 0);
    hero.addAttribute("PUNCH_DAMAGE", 10.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 12.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 400, 0);
    
    hero.addKeyBind("SPELL_MENU", "Trident Magic", 1);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 2);
    hero.addKeyBind("SHIELD", "Trident", 3);
    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 4);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 5);
    
    hero.addAttributeProfile("TRIDENT", tridentProfile);
    hero.setAttributeProfile(getAttributeProfile);
    hero.setModifierEnabled(isModifierEnabled);
    hero.setKeyBindEnabled(isKeyBindEnabled);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  


}

function tridentProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 12.5, 0);
    profile.addAttribute("STEP_HEIGHT", 0.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "TRIDENT" : null;
}

function canAim(entity) {
    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:grab_id") > -1;
}

function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
        case "fiskheroes:spellcasting":
            return !entity.getData("fiskheroes:shield") < 1;
        case "fiskheroes:controlled_flight":
            return entity.isInWater();
        case "fiskheroes:leaping":
            return entity.getData("fiskheroes:speeding");
    default:
        return true;
    }
}
function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
            case "SPELL_MENU":
                return entity.getData("fiskheroes:shield") 
    default:
            return true;
}
}
