var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Aquaman Harpoon Hand");
    hero.setTier(7);
 
    hero.setChestplate("Suit");
    
    hero.addPowers("eden:atlantean_royalty_amputated");
    hero.addAttribute("BASE_SPEED_LEVELS", 1.0, 0);
    hero.addAttribute("PUNCH_DAMAGE", 10.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 12.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 400, 0);
    
    hero.addKeyBind("WEB_ZIP", "Launch Harpoon", 3);
    hero.addKeyBindFunc("func_WEB_SWINGING", webSwingingKey, "Launch Harpoon", 1);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 2);
    hero.addKeyBind("BLADE", "Activate Harpoon", 1);
    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 4);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 5);
    
    hero.addAttributeProfile("BLADE", bladeProfile);
    hero.setModifierEnabled(isModifierEnabled);
    hero.setKeyBindEnabled(isKeyBindEnabled);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  


}

function webSwingingKey(player, manager) {
    var flag = player.getData("fiskheroes:web_swinging");

    if (!flag) {
        manager.setDataWithNotify(player, "fiskheroes:blade", true);
    }

    manager.setDataWithNotify(player, "fiskheroes:web_swinging", !flag);
    return true;
}

function webWingsKey(player, manager) {
    if (player.isOnGround() || player.isInWater()) {
        return false;
    }

    var flag = player.getData("fiskheroes:blade");

    if (!flag) {
        manager.setDataWithNotify(player, "fiskheroes:web_swinging", true);
    }

    manager.setDataWithNotify(player, "fiskheroes:blade", !flag);
    return true;
}

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 12.0, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}

function canAim(entity) {
    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:grab_id") > -1;
}

function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
        case "fiskheroes:controlled_flight":
            return entity.isInWater();
        case "fiskheroes:leaping":
            return entity.getData("fiskheroes:speeding");
    default:
        return true;
    }
}
function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
            case "func_WEB_SWINGING'":
                return entity.getData("fiskheroes:blade")
            case "web_zip'":
                return !entity.getData("fiskheroes:blade")
    default:
            return true;
}
}
