var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Behemoth");
    hero.setVersion("Dino-Squad");
    hero.setTier(7);
    
    hero.setHelmet("Helmet");
    hero.setChestplate("Chestpiece");
    hero.setLeggings("Leggings");
    hero.setBoots("Boots");
    
    hero.addPowers("eden:sauropod_mutation");
    hero.addAttribute("PUNCH_DAMAGE", 15.0, 0);
    hero.addAttribute("WEAPON_DAMAGE", 8.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 3.5, 0);
    hero.addAttribute("FALL_RESISTANCE", 2.0, 1);
    hero.addAttribute("BASE_SPEED_LEVELS", 1.0, 0);
    
    hero.addKeyBind("TELEKINESIS", "Grab", 3);
	hero.addKeyBind("SIZE_MANIPULATION", "key.sizeManipulation", 5);
	hero.addKeyBind("GROUND_SMASH", "key.groundSmash", 4);
    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 1);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 2);
    
    hero.setDefaultScale(1.0);
    hero.setHasProperty(hasProperty);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    }); 
}

function hasProperty(entity, property) {
    return property == "BREATHE_SPACE";
}
function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
        case "fiskheroes:leaping":
            return entity.getData("fiskheroes:speeding");
    default:
        return true;
    }
}