function init(hero) {
    hero.setName("Black Panther");
    hero.setTier(7);

    hero.setChestplate("suit");

    hero.addPowers("eden:black_panther_suit", "eden:operator");
    hero.addAttribute("PUNCH_DAMAGE", 7.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 9.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 1.0, 1);
    hero.addAttribute("SPRINT_SPEED", 0.60, 1);
    hero.addAttribute("STEP_HEIGHT", 0.5, 0);

    hero.addKeyBind("BLADE", "key.claws", 1);
    hero.addKeyBind("UTILITY_BELT", "key.utilityBelt", 2);
    hero.addKeyBind("SPELL_MENU", "Release Kinetic Energy", 3);
    hero.addKeyBind("WEB_ZIP", "Grapple Zip", 4);

    hero.addAttributeProfile("CLAWS", clawsProfile);
    hero.setAttributeProfile(getProfile);
    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("CLAWS", {"types": {"SHARP": 1.0}});
    hero.setHasPermission((entity, permission) => permission == "USE_GUN" || permission == "USE_GRAPPLING_GUN");
}

function clawsProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 10.5, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "CLAWS" : null;
}
