function init(hero) {
    hero.setName("Blue Lantern Saint Walker");
    hero.setTier(8);

    hero.setChestplate("Ring");
    hero.addPrimaryEquipment("fiskheroes:chokuto", true, item => !item.nbt().getBoolean("Dual"));
    hero.addPrimaryEquipment("fiskheroes:ruptures_scythe", true);
    hero.addPrimaryEquipment("fiskheroes:captain_americas_shield{Electromagnetic:1,display:{Name:\"Blue Lantern Construct\"}}", true);

    hero.addPowers("eden:blue_power_ring");
    hero.addAttribute("PUNCH_DAMAGE", 6.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 12.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 100.5, 0);

    hero.addKeyBind("CHARGED_BEAM", "Lantern Beam", 1);
    hero.addKeyBind("ENERGY_PROJECTION", "Ring Grab", 2);
    hero.addKeyBind("TELEKINESIS", "Ring Grab", 2);
    hero.addKeyBind("SHIELD", "Wall Construct", 4);
    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBind("UTILITY_BELT", "Web Construct", 1);
    hero.addKeyBind("BLADE", "Sword Construct", 3);
    hero.addKeyBind("SHIELD_THROW", "key.shieldThrow", 5);

    hero.setHasPermission(hasPermission);
    hero.supplyFunction("canAim", canAim);

    hero.setHasProperty(hasProperty);

    hero.setKeyBindEnabled(isKeyBindEnabled);

    hero.addAttributeProfile("BLADE", bladeProfile);
}

function hasPermission(entity, permission) {
    return permission == "USE_CHRONOS_RIFLE" || permission == "USE_SHIELD";
}

function canAim(entity) {
    return entity.getHeldItem().name() == "fiskheroes:chronos_rifle";
}

function hasProperty(entity, property) {
    return property == "BREATHE_SPACE";
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
            case "UTILITY_BELT":
                return entity.isSneaking();
            case "GROUND_SMASH":
                return entity.getData("fiskheroes:dyn/giant_mode");
            case "SHIELD_THROW":
                return entity.getHeldItem().name() == "fiskheroes:captain_americas_shield";
    default:
            return true;
}
}

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 10.0, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}