var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Bolt");
    hero.setTier(8);
    
    hero.setChestplate("Suit");
	
    hero.addPowers("eden:speed_olympian_demigod");
    hero.addAttribute("PUNCH_DAMAGE", 12.0, 0);
    hero.addAttribute("WEAPON_DAMAGE", 12.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 1);
	hero.addAttribute("MAX_HEALTH", 12.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 7.0, 0);

    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 1);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 2);
    hero.addKeyBind("CHARGED_BEAM", "Lightning Blast", 3);
    hero.addKeyBind("EARTHQUAKE", "Speed Barrage", 4);
    hero.addKeyBind("INTANGIBILITY", "Phase", 5);
    hero.addKeyBind("SHIELD", "Scepter", 4);

    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);
    hero.setAttributeProfile(getAttributeProfile);

    hero.addAttributeProfile("SCEPTER", scepterProfile);
    
    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  
    } 
 
function scepterProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 14.5, 0);
    profile.addAttribute("STEP_HEIGHT", 0.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "SCEPTER" : null;
}
    function isKeyBindEnabled(entity, keyBind) {
        switch (keyBind) {
                case "EARTHQUAKE":
                    return entity.getData("fiskheroes:speeding") && entity.motion().length() >= 3.0 && entity.getHeldItem().isEmpty()
                case "INTANGIBILITY":
                    return entity.getData("fiskheroes:speeding") && entity.motion().length() >= 0.5 && entity.getHeldItem().isEmpty()
                case "CHARGED_BEAM":
                    return entity.getData("fiskheroes:shield") 
        default:
                return true;
    }
    }

    function isModifierEnabled(entity, modifier) {
        if (modifier.name() == "fiskheroes:frost_walking") {
            return entity.getData("fiskheroes:speeding");
        }
        if (modifier.name() == "fiskheroes:controlled_flight") {
            return entity.getData("fiskheroes:speeding");
        }
        return true;
    }