function init(hero) {
    hero.setName("Captain America");
    hero.setTier(6);
    

    hero.setChestplate("suit");

    hero.addPrimaryEquipment("fiskheroes:captain_americas_shield{Electromagnetic:1}", true);
    hero.addPrimaryEquipment("fiskheroes:grappling_gun", true);
    hero.addPrimaryEquipment("fiskheroes:desert_eagle", true, item => !item.nbt().getBoolean("Dual"));

    hero.addPowers("eden:super_soldier");
	
    hero.addAttribute("PUNCH_DAMAGE", 8.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 6.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 1.5, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.5, 1);
    hero.addAttribute("STEP_HEIGHT", 0.5, 0);

    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBind("GUN_RELOAD", "key.reload", 1);
    hero.addKeyBind("SHIELD_THROW", "key.shieldThrow", 2);
    hero.addKeyBind("UTILITY_BELT", "key.utilityBelt", 3);
   
    hero.setHasPermission(hasPermission);
    hero.supplyFunction("canAim", canAim);

    hero.setKeyBindEnabled(isKeyBindEnabled);

}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
    case "GUN_RELOAD":
        return entity.getHeldItem().isGun() && !entity.getData("fiskheroes:aiming");
    case "SHIELD_THROW":
        return entity.getHeldItem().name() == "fiskheroes:captain_americas_shield";
    default:
        return true;
    }
}

function hasPermission(entity, permission) {
    return permission == "USE_GUN" || permission == "USE_SHIELD" || permission == "USE_GRAPPLING_GUN";
}

function canAim(entity) {
    return entity.getHeldItem().isGun();
}