var speedster_base = implement("fiskheroes:external/speedster_base");
var falcon_base = implement("fiskheroes:external/falcon_base");
var super_boost = implement("fiskheroes:external/super_boost_with_cooldown");

function init(hero) {
    hero.setName("Dinoboy");
    hero.setVersion("Dino-Squad");
    hero.setTier(8);
    
    hero.setHelmet("Helmet");
    hero.setChestplate("Chestpiece");
    hero.setLeggings("Leggings");
    hero.setBoots("Boots");
	
    hero.addPowers("eden:dino_mutation");
    hero.addAttribute("PUNCH_DAMAGE", 12.0, 0);
    hero.addAttribute("WEAPON_DAMAGE", 2.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 1);
	hero.addAttribute("MAX_HEALTH", 18.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 3.0, 0);
 
    hero.addKeyBind("SUPER_SPEED", "Torrenite Divinity", 1);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 2);
    hero.addKeyBind("SONIC_WAVES", "Percussion", 4);
    hero.addKeyBind("SHIELD", "Stegosaur Spikes", 4);
	hero.addKeyBind("SIZE_MANIPULATION", "Ground Smash/ Size Manipulation", 5);
    hero.addKeyBind("CHARGED_BEAM", "Torrenite Blast", 3);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash/ Size Manipulation", 5); 

    hero.setDefaultScale(0.90);

    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  
    
    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("SHIELD", {
        "types": {
            "BLUNT": 0.7,
            "SHARP": 0.3
        }
    });
    super_boost = super_boost.create(200, 150, 20);
    falcon_base.init(hero, super_boost, 2, 0.25, (entity, manager) => {
        if (entity.getData("fiskheroes:shield")) {
            manager.setData(entity, "fiskheroes:flying", false);
        }
    });
    } 
    function isModifierEnabled(entity, modifier) {
        switch (modifier.name()) {
        case "fiskheroes:controlled_flight":
            return (entity.getData("fiskheroes:flight_timer") > 0 || !entity.getData("fiskheroes:shield")) && super_boost.isModifierEnabled(entity, modifier);
        case "fiskheroes:shield":
            return !(entity.isSprinting() && entity.getData("fiskheroes:flying"));
        default:
            return true;
        }
    }
    function isKeyBindEnabled(entity, keyBind) {
        switch (keyBind) {
                case "SONIC_WAVES":
                    return entity.isSneaking();
                case "GROUND_SMASH":
                    return entity.isSneaking();
                case "SIZE_MANIPULATION":
                    return !entity.isSneaking();
                case "CHARGED_BEAM":
                    return entity.getData("fiskheroes:speeding") && entity.getHeldItem().isEmpty()
                default:
                    return true;
            }
    }

    function shieldProfile(profile) {
        profile.inheritDefaults();
        profile.addAttribute("PUNCH_DAMAGE", 8.5, 0);
    }
    
    function getProfile(entity) {
        return entity.getData("fiskheroes:shield") ? "SHIELD" : null;
    }