var super_boost = implement("fiskheroes:external/super_boost");

function init(hero) {
    hero.setName("Doctor Strange");
    hero.setTier(5);

    hero.setChestplate("Cloak");


    hero.addPowers("eden:eldritch_magic");
    hero.addAttribute("PUNCH_DAMAGE", 4.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 6.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 8.0, 0);

    hero.addKeyBind("ENERGY_PROJECTION", "key.energyProjection", 3);
    hero.addKeyBind("SPELL_MENU", "Spells", 3);
    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBind("BLADE", "key.blade", 1);
    hero.addKeyBind("SHIELD", "Magic", 1);
    hero.addKeyBind("TELEPORT", "key.teleport", 4);
    hero.addKeyBind("SUPER_SPEED", "Time Movement", 1);
    hero.addKeyBind("SLOW_MOTION", "Eye of Agamoto", 2);
    hero.addKeyBind("TELEKINESIS", "Telekinisis", 5);
    hero.addKeyBind("GRAVITY_MANIPULATION", "key.gravityManip", 5);

    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);
    hero.setHasProperty((entity, property) => property == "MASK_TOGGLE");
    hero.supplyFunction("canAim", canAim);


    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("BLADE", {
        "types": {
            "SHARP": 1.0,
            "FIRE": 0.2
        }
    });

}

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 7.0, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}

function isModifierEnabled(entity, modifier) {
    return modifier.name() != "fiskheroes:shield" || !entity.getData("fiskheroes:blade");
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
    case "SHIELD":
        return !entity.getData("fiskheroes:shield") || !(entity.getData("fiskheroes:shield") && entity.getData("fiskheroes:aiming"));
    case "BLADE":
        return entity.getData("fiskheroes:shield") && entity.getData("fiskheroes:aiming") || entity.getData("fiskheroes:blade") || entity.isBookPlayer();
    case "SPELL_MENU":
        return !entity.getData("fiskheroes:blade") && !entity.getData("fiskheroes:shield");
    case "ENERGY_PROJECTION":
        return entity.getData("fiskheroes:shield") 
    case "GRAVITY_MANIPULATION":
        return entity.isSneaking(); 
    case "SUPER_SPEED":
        return entity.getData("fiskheroes:slow_motion") 
    default:
        return true;
    }
}

function canAim(entity) {
    return entity.getData("fiskheroes:shield") && entity.getData("fiskheroes:shield_blocking_timer") == 0;
}

function isModifierEnabled(entity, modifier) {
    if (modifier.name() == "fiskheroes:super_speed") {
        return entity.getData("fiskheroes:slow_motion");
    }
    return true;
}

