var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Emperor");
    hero.setTier(5);

    hero.setHelmet("item.superhero_armor.piece.cowl");
    hero.setChestplate("item.superhero_armor.piece.chestpiece");
    hero.setLeggings("item.superhero_armor.piece.pants");
    hero.setBoots("item.superhero_armor.piece.boots");

    hero.addPowers("eden:north_guardian");
    hero.addAttribute("PUNCH_DAMAGE", 13.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 13.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 3.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 4000.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 7.0, 0);

    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 1);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 2);
    hero.addKeyBind("SHIELD", "Penguin Shield", 3);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash/Cold Breathe", 5); 
    hero.addKeyBind("UTILITY_BELT", "key.utilityBelt", 4);
    hero.addKeyBind("CHARGED_BEAM", "Cold Breathe", 5);


    hero.addAttributeProfile("SHIELD", shieldProfile);
    hero.setAttributeProfile(getProfile);
    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("SHIELD", {
        "types": {
            "BLUNT": 0.7,
            "SHARP": 0.3
        }
    });

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });
}

function shieldProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 9.5, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "SHIELD" : null;
}