var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("The Flash (Wally West)");
    hero.setTier(8);
    
    hero.setChestplate("Suit");
    hero.addEquipment("fiskheroes:flash_ring");
	
    hero.addPowers("eden:speed_force");
    hero.addAttribute("PUNCH_DAMAGE", 6.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 1);
    hero.addAttribute("BASE_SPEED_LEVELS", 9.0, 0);
    hero.addAttribute("STEP_HEIGHT", 0.5, 0);

    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 1);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 2);
    hero.addKeyBind("EARTHQUAKE", "Speed Barrage", 5);
    hero.addKeyBind("TENTACLES", "Toggle Wall Run (Double Jump)", 1);
    hero.addKeyBind("SONIC_WAVES", "Vortex", 3);
    hero.addKeyBind("CHARGED_BEAM", "Vortex", 3);
    hero.addKeyBind("CHARGE_ENERGY", "Charge Lightning", 4);
    hero.addKeyBind("INTANGIBILITY", "Phase", 3);

    var speedPunch = speedster_base.createSpeedPunch(hero);
    hero.setDamageProfile(entity => speedPunch.get(entity, null));
    
    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    }); 

	hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);

    } 
    function isKeyBindEnabled(entity, keyBind) {
        switch (keyBind) {
                case "EARTHQUAKE":
                    return entity.getData("fiskheroes:speeding") && entity.motion().length() >= 2.0 && entity.getHeldItem().isEmpty()
                case "CHARGE_ENERGY":
                    return entity.getData("fiskheroes:speeding") && entity.motion().length() >= 1.0 && entity.getHeldItem().isEmpty()
                    case "SONIC_WAVES":
                        return entity.isSneaking();
                    case "CHARGED_BEAM":
                        return entity.isSneaking();
        default:
                return true;
    }
    }

    function isModifierEnabled(entity, modifier) {
        if (modifier.name() == "fiskheroes:frost_walking") {
            return entity.getData("fiskheroes:speeding");
        }
        return true;
    }