
function init(hero) {
    hero.setName("Gambit");
    hero.setTier(8);
    
    hero.setChestplate("Suit");
    hero.addPrimaryEquipment("fiskheroes:bo_staff", true);
	
    hero.addPowers("eden:mutant_gambit");
    hero.addAttribute("PUNCH_DAMAGE", 5.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 7.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 3000.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.10, 1);

    hero.addKeyBind("CHARGE_ENERGY", "Charge Cards", 1);
    hero.addKeyBind("GROUND_SMASH", "Charge Staff(Right-Click for Energy Release)", 2); 
    hero.addKeyBind("BLADE", "Throwing Cards", 3);

    hero.setKeyBindEnabled(isKeyBindEnabled);
     
    } 

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 9.0, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
            case "CHARGE_ENERGY":
                return entity.getData("fiskheroes:blade") 
            case "GROUND_SMASH":
                return entity.getHeldItem().name() == "fiskheroes:bo_staff"; 
    default:
            return true;
}
}