function init(hero) {
    hero.setName("Green Lantern Jon Stewart");
    hero.setTier(8);

    hero.setChestplate("Ring");
    hero.addPrimaryEquipment("fiskheroes:chronos_rifle", true);
    hero.addPrimaryEquipment("fiskheroes:chokuto", true, item => !item.nbt().getBoolean("Dual"));
    hero.addPrimaryEquipment("minecraft:stained_glass", true);
    hero.addPrimaryEquipment("minecraft:emerald_block", true);

    hero.addPowers("eden:green_power_ring","eden:lantern_big");
    hero.addAttribute("PUNCH_DAMAGE", 7.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 12.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 100.5, 0);

    hero.addKeyBind("CHARGED_BEAM", "Lantern Beam", 1);
    hero.addKeyBind("ENERGY_PROJECTION", "Ring Grab", 2);
    hero.addKeyBind("TELEKINESIS", "Ring Grab", 2);
    hero.addKeyBind("SHIELD", "Wall Construct", 3);
    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBindFunc("func_GIANT_MODE", giantModeKey, "Giant Construct", 5);
    hero.addKeyBind("UTILITY_BELT", "Web Construct", 1);
    hero.addKeyBind("GROUND_SMASH", "key.groundSmash", 1);
    hero.addKeyBind("BLADE", "Jackhammer Construct", 4);
    hero.addKeyBind("EARTHQUAKE", "Jackhammer Construct", 4);

    hero.setHasPermission(hasPermission);
    hero.supplyFunction("canAim", canAim);

    hero.setHasProperty(hasProperty);

    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);

    hero.addAttributeProfile("GIANT_MODE", giantProfile);
    hero.setAttributeProfile(getAttributeProfile);

    hero.setTierOverride(getTierOverride);

    hero.addAttributeProfile("BLADE", bladeProfile);
}

function giantModeKey(player, manager) {
    var flag = player.getData("fiskheroes:dyn/giant_mode");
    manager.setData(player, "fiskheroes:dyn/giant_mode", !flag);
    manager.setData(player, "fiskheroes:size_state", flag ? -1 : 1);
    return true;
}

function getTierOverride(entity) {
    return entity.getData("fiskheroes:dyn/giant_mode") ? 6 : 4;
}

function giantProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 15.0, 0);
    profile.addAttribute("WEAPON_DAMAGE", 17.0, 0);
    profile.addAttribute("FALL_RESISTANCE", 7000000.0, 0);
    profile.addAttribute("SPRINT_SPEED", 0.35, 1);
    profile.addAttribute("JUMP_HEIGHT", 4.5, 0);
    profile.addAttribute("KNOCKBACK", 1.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:dyn/giant_mode_timer") > 0 ? "GIANT_MODE" : null;
}

function isModifierEnabled(entity, modifier) {
    return modifier.name() != "fiskheroes:size_manipulation" || (modifier.id() == "giant") == (entity.getData("fiskheroes:dyn/giant_mode_timer") > 0 || entity.getData("fiskheroes:dyn/giant_mode"));
}

function hasPermission(entity, permission) {
    return permission == "USE_CHRONOS_RIFLE";
}

function canAim(entity) {
    return entity.getHeldItem().name() == "fiskheroes:chronos_rifle";
}

function hasProperty(entity, property) {
    return property == "BREATHE_SPACE";
}
function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
            case "UTILITY_BELT":
                return entity.isSneaking();
            case "func_GIANT_MODE":
                return entity.getData("fiskheroes:size_state") == 0 && (entity.getData("fiskheroes:dyn/giant_mode") || entity.getData("fiskheroes:dyn/giant_mode_cooldown") == 0);
            case "SIZE_MANIPULATION":
                return !entity.getData("fiskheroes:dyn/giant_mode");
            case "GROUND_SMASH":
                return entity.getData("fiskheroes:dyn/giant_mode");

    default:
            return true;
}
}

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 12.0, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}
