var speedster_base = implement("fiskheroes:external/speedster_base");
var falcon_base = implement("fiskheroes:external/falcon_base");
var super_boost = implement("fiskheroes:external/super_boost_with_cooldown");

function init(hero) {
    hero.setName("Hybrid");
    hero.setTier(8);
    
    hero.setChestplate("suit");
	
    hero.addPowers("eden:hybrid_mutation");
    hero.addAttribute("PUNCH_DAMAGE", 12.0, 0);
    hero.addAttribute("WEAPON_DAMAGE", 2.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 1);
	hero.addAttribute("MAX_HEALTH", 18.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 3.0, 0);
 
    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 1);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 2);
    hero.addKeyBind("SONIC_WAVES", "Percussion", 3);
    hero.addKeyBind("SHIELD", "Claw", 3);
    hero.addKeyBindFunc("func_GIANT_MODE", giantModeKey, "key.giantMode", 4);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 5); 

    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);

    hero.addAttributeProfile("GIANT_MODE", giantProfile);
    hero.setTierOverride(getTierOverride);
    hero.setAttributeProfile(getAttributeProfile);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  
    
    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("SHIELD", {
        "types": {
            "BLUNT": 0.7,
            "SHARP": 0.3
        }
    });
    super_boost = super_boost.create(200, 150, 20);
    falcon_base.init(hero, super_boost, 2, 0.25, (entity, manager) => {
        if (entity.getData("fiskheroes:shield")) {
            manager.setData(entity, "fiskheroes:flying", false);
        }
    });
    } 

    function giantModeKey(player, manager) {
        var flag = player.getData("fiskheroes:dyn/giant_mode");
        manager.setData(player, "fiskheroes:dyn/giant_mode", !flag);
        manager.setData(player, "fiskheroes:size_state", flag ? -1 : 1);
        return true;
    }

    function getTierOverride(entity) {
        return entity.getData("fiskheroes:dyn/giant_mode") ? 6 : 4;
    }

    function giantProfile(profile) {
        profile.inheritDefaults();
        profile.addAttribute("PUNCH_DAMAGE", 15.0, 0);
        profile.addAttribute("WEAPON_DAMAGE", 17.0, 0);
        profile.addAttribute("FALL_RESISTANCE", 7000000.0, 0);
        profile.addAttribute("SPRINT_SPEED", 0.35, 1);
        profile.addAttribute("JUMP_HEIGHT", 4.5, 0);
        profile.addAttribute("KNOCKBACK", 1.5, 0);
    }
    function getAttributeProfile(entity) {
        return entity.getData("fiskheroes:dyn/giant_mode_timer") > 0 ? "GIANT_MODE" : null;
    }

    function isModifierEnabled(entity, modifier) {
        return modifier.name() != "fiskheroes:size_manipulation" || (modifier.id() == "giant") == (entity.getData("fiskheroes:dyn/giant_mode_timer") > 0 || entity.getData("fiskheroes:dyn/giant_mode"));
    }
    function isKeyBindEnabled(entity, keyBind) {
        switch (keyBind) {
                case "SONIC_WAVES":
                    return entity.isSneaking();
                case "func_GIANT_MODE":
                    return entity.getData("fiskheroes:size_state") == 0 && (entity.getData("fiskheroes:dyn/giant_mode") || entity.getData("fiskheroes:dyn/giant_mode_cooldown") == 0);
                case "SIZE_MANIPULATION":
                        return !entity.getData("fiskheroes:dyn/giant_mode");
                default:
                    return true;
            }
    }

    function shieldProfile(profile) {
        profile.inheritDefaults();
        profile.addAttribute("PUNCH_DAMAGE", 17.5, 0);
    }
    
    function getProfile(entity) {
        return entity.getData("fiskheroes:shield") ? "SHIELD" : null;
    }