function init(hero) {
    hero.setName("Iceman/ Robert Drake");
    hero.setTier(4);
    
    hero.setChestplate("Suit");
    
    hero.addPowers("eden:mutant_iceman");
    hero.addAttribute("PUNCH_DAMAGE", 6, 0);
    hero.addAttribute("JUMP_HEIGHT", 1.5, 0);
	hero.addAttribute("FALL_RESISTANCE", 1.0, 1);

	hero.addKeyBind("CHARGED_BEAM", "Frost Beam", 1);
    hero.addKeyBind("BLADE", "key.iceSpike", 2);
    hero.addKeyBind("STEEL_TRANSFORM", "Ice Form", 3);
    hero.addKeyBind("SHIELD", "Ice Wall", 4);
   
    hero.addAttributeProfile("BLADE", bladeProfile);
    hero.setAttributeProfile(getAttributeProfile);
    hero.setDamageProfile(getDamageProfile);
    hero.addDamageProfile("BLADE", {
        "types": {
            "SHARP": 1.0,
            "COLD": 0.4
        }
    });
    hero.addDamageProfile("ICE_PUNCH", {
        "types": {
            "BLUNT": 1.0,
            "COLD": 0.2
        }
    });
}

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 7.0, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}

function getDamageProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}

function getTierOverride(entity) {
    return entity.getData("fiskheroes:dyn/steeled") ? 7 : 5;
}

function steelProfile(profile) {
    profile.addAttribute("PUNCH_DAMAGE", 8, 0);
    profile.addAttribute("JUMP_HEIGHT", 1.5, 0);
	profile.addAttribute("FALL_RESISTANCE", 1.0, 1);
    profile.addAttribute("SPRINT_SPEED", 0.1, 1);
    profile.addAttribute("STEP_HEIGHT", 0.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:dyn/steeled") ? "STEEL" : null;
}

function isModifierEnabled(entity, modifier) {
    return modifier.name() == "fiskheroes:transformation" || modifier.name() == "fiskheroes:cooldown" || entity.getData("fiskheroes:dyn/steeled");
}