var utils = implement("fiskheroes:external/utils");

function init(hero) {
    hero.setName("Jaakuna");
    hero.setTier(10);
    
    hero.setChestplate("suit");
    hero.addPrimaryEquipment("fiskheroes:chokuto", true, item => !item.nbt().getBoolean("Dual"));
    
    hero.addPowers("eden:evil_dragon_magic");
    
    hero.addKeyBind("CHARGED_BEAM", "Atomic Ray", 1);
    hero.addKeyBind("INTANGIBILITY", "key.intangibility", 4);
    hero.addKeyBind("SPELL_MENU", "key.spellMenu", 2);
    hero.addKeyBind("SHIELD", "Forcefield", 3);	
    hero.addKeyBind("AIM", "key.shadowChain", 5);
    hero.addKeyBind("TELEKINESIS", "key.shadowChain", 5);
    hero.addKeyBind("SHADOWDOME", "key.shadowDome", 3);

    hero.addAttribute("FALL_RESISTANCE", 50000.0, 0);
    hero.addAttribute("PUNCH_DAMAGE", 14.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.6, 1);

    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setHasProperty(hasProperty);
    hero.supplyFunction("canAim", canAim);

    hero.setTickHandler((entity, manager) => {
        utils.flightOnIntangibility(entity, manager);
    });

}
function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
    case "INTANGIBILITY":
        return !entity.isSneaking();
    case "CHARGED_BEAM":
        return entity.isSneaking();
    case "SHIELD":
        return entity.isSneaking();
    case "SHADOWDOME":
        return entity.isSneaking();

    case entity.getData("fiskheroes:lightsout"):
        return keyBind == "SHADOWDOME";
        
    case entity.getData("fiskheroes:telekinesis"):

        return keyBind != "TELEKINESIS" && keyBind != "AIM" || entity.getHeldItem().isEmpty();
    default:
            return true;
        }
}
function hasProperty(entity, property) {
    return property == "BREATHE_SPACE"; 
}

function canAim(entity) {
    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:grab_id") > -1;
}