var utils = implement("fiskheroes:external/utils");

function init(hero) {
    hero.setName("Kai Long");
    hero.setAliases("The Sun Dragon of the East");
    hero.setTier(10);
    
    hero.setHelmet("item.superhero_armor.piece.head");
    hero.setChestplate("item.superhero_armor.piece.torso");
    hero.setLeggings("item.superhero_armor.piece.legs");
    hero.setBoots("item.superhero_armor.piece.boots");
    hero.addPrimaryEquipment("fiskheroes:chokuto", true, item => !item.nbt().getBoolean("Dual"));
    
    hero.addPowers("eden:dragon_magic");
    
    hero.addKeyBind("CHARGED_BEAM", "Atomic Ray", 1);
    hero.addKeyBind("INTANGIBILITY", "thermal form", 2);
    hero.addKeyBind("SPELL_MENU", "key.spellMenu", 3);
    hero.addKeyBind("SHIELD", "Forcefield", 4);	
    hero.addKeyBind("STEEL_TRANSFORM", "Dragon Form", 5);

    hero.addAttribute("FALL_RESISTANCE", 50000.0, 0);
    hero.addAttribute("PUNCH_DAMAGE", 14.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.6, 1);

    hero.setHasProperty(hasProperty);

    hero.setTickHandler((entity, manager) => {
        utils.flightOnIntangibility(entity, manager);
    });

}
function hasProperty(entity, property) {
    return property == "BREATHE_SPACE"; 
}

function getTierOverride(entity) {
    return entity.getData("fiskheroes:dyn/steeled") ? 7 : 5;
}

function steelProfile(profile) {
    profile.addAttribute("JUMP_HEIGHT", 2.5, 0);
    profile.addAttribute("FALL_RESISTANCE", 50000.0, 0);
    profile.addAttribute("PUNCH_DAMAGE", 14.0, 0);
    profile.addAttribute("SPRINT_SPEED", 0.6, 1);
    profile.addAttribute("IMPACT_DAMAGE", 0.15, 1);
    profile.addAttribute("MAX_HEALTH", 16.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:dyn/steeled") ? "STEEL" : null;
}

function isModifierEnabled(entity, modifier) {
    return modifier.name() == "fiskheroes:transformation" || modifier.name() == "fiskheroes:cooldown" || entity.getData("fiskheroes:dyn/steeled");
}