var utils = implement("fiskheroes:external/utils");

function init(hero) {
    hero.setName("La Muerta");
    hero.setTier(9);

    hero.setHelmet("item.superhero_armor.piece.head");
    hero.setChestplate("item.superhero_armor.piece.torso");
    hero.setLeggings("item.superhero_armor.piece.legs");
    hero.setBoots("item.superhero_armor.piece.boots");

    hero.addPowers("eden:brujeria");
    hero.addAttribute("PUNCH_DAMAGE", 10.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.1, 1);
    hero.addAttribute("JUMP_HEIGHT", 1.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 100.0, 1);

    hero.addKeyBind("INTANGIBILITY", "Fantasma", 3);
    hero.addKeyBind("INVISIBILITY", "key.invisibility", 4);
    hero.addKeyBind("SPELL_MENU", "Brujeria", 2);
    hero.addKeyBind("TENTACLES", "Bone Shadow Tentacles", 1);
    hero.addKeyBind("TENTACLE_JAB", "key.tentacleJab", 5);
    hero.addKeyBind("TENTACLE_GRAB", "key.tentacleGrab", 4);

    hero.setDefaultScale(1.1);
    hero.setHasProperty((entity, property) => property == "BREATHE_SPACE");

    hero.setTickHandler((entity, manager) => {
        utils.flightOnIntangibility(entity, manager);
    });
}