var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("The Leviathan / Isra");
    hero.setTier(8);
    
    hero.setHelmet("Helmet");
    hero.setChestplate("Chestpiece");
    hero.setLeggings("Leggings");
    hero.setBoots("Boots");
	
    hero.addPowers("eden:torrenite_divinity");
    hero.addAttribute("PUNCH_DAMAGE", 14.0, 0);
    hero.addAttribute("WEAPON_DAMAGE", 16.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 1);
	hero.addAttribute("MAX_HEALTH", 18.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 4.0, 0);

    hero.addKeyBind("CHARGED_BEAM", "Torrenite Beam", 3);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 5); 
    hero.addKeyBind("SUPER_SPEED", "Torrenite Divinity", 1);
    hero.addKeyBind("SLOW_MOTION", "Hightened perseption", 2);

	hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  

    hero.setHasProperty((entity, property) => property == "BREATHE_SPACE");
    } 
    function isKeyBindEnabled(entity, keyBind) {
        switch (keyBind) {
                case "CHARGED_BEAM":
                    return entity.getData("fiskheroes:speeding") && entity.getHeldItem().isEmpty()
        default:
                return true;
    }
    }

    function isModifierEnabled(entity, modifier) {
        if (modifier.name() == "fiskheroes:leaping") {
            return entity.getData("fiskheroes:speeding");
        }
        return true;
    }