function init(hero) {
    hero.setName("Lun Ra");
    hero.setAliases("Sheek Scientist");
    hero.setTier(7);

    hero.setChestplate("Suit");
    hero.addPrimaryEquipment("fiskheroes:chronos_rifle", true);
    hero.addPrimaryEquipment("fiskheroes:chokuto", true, item => !item.nbt().getBoolean("Dual"));

    hero.addPowers("eden:sheek_armor");
    hero.addAttribute("PUNCH_DAMAGE", 7.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 8.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 1.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 7.0, 0);
    hero.addAttribute("IMPACT_DAMAGE", 0.3, 1);

    hero.addKeyBind("SHIELD", "Shield", 2);
    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBind("UTILITY_BELT", "key.utilityBelt", 3);

    hero.setHasPermission(hasPermission);
    hero.supplyFunction("canAim", canAim);
    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);
    hero.supplyFunction("canDischargeEnergy", isHoldingChokuto);

    hero.addAttributeProfile("SHIELD", shieldProfile);
    hero.setAttributeProfile(getProfile);

    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("SHIELD", {
        "types": {
            "BLUNT": 0.9,
            "SHARP": 0.8
        }
    });
}

function isKeyBindEnabled(entity, keyBind) {
    return keyBind != "CHARGE_ENERGY" || isHoldingChokuto(entity);
}

function isModifierEnabled(entity, modifier) {
    return  modifier.name() != "fiskheroes:energy_manipulation" || isHoldingChokuto(entity);
}

function hasPermission(entity, permission) {
    return permission == "USE_CHRONOS_RIFLE";
}

function canAim(entity) {
    return entity.getHeldItem().name() == "fiskheroes:chronos_rifle";
}

function isHoldingChokuto(entity) {
    return entity.getHeldItem().name() == "fiskheroes:chokuto";
}

function shieldProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 9.5, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "SHIELD" : null;
}