var utils = implement("fiskheroes:external/utils");

function init(hero) {
    hero.setName("Martian Manhunter Comics New 52");
    hero.setTier(9);

    hero.setChestplate("suit");

    hero.addPowers("eden:martian_physiology");
    hero.addAttribute("PUNCH_DAMAGE", 10.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.1, 1);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 500.0, 0);

    hero.addKeyBind("TENTACLE_GRAB", "Tentacle Grab/ Intangibility", 2);
    hero.addKeyBind("TENTACLE_STRIKE", "Tentacle Strike/ Psychic Blast", 3);
    hero.addKeyBind("TENTACLES", "key.tentacles", 1);
    hero.addKeyBind("HEAT_VISION", "Heat Vision/ Size Manipulation", 4);
	hero.addKeyBind("SIZE_MANIPULATION", "Heat Vision/ Size Manipulation", 4);
    hero.addKeyBind("SPELL_MENU", "Clones", 5);
    hero.addKeyBind("INTANGIBILITY", "key.intangibility", 2);
    hero.addKeyBind("CHARGED_BEAM", "Psychic Blast", 3);

    hero.setDefaultScale(1.1);
    hero.setHasProperty((entity, property) => property == "BREATHE_SPACE");

    hero.setKeyBindEnabled(isKeyBindEnabled);

    hero.setTickHandler((entity, manager) => {
        utils.flightOnIntangibility(entity, manager);
    });

}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
        case "CHARGED_BEAM":
            return entity.isSneaking();
                case "INTANGIBILITY":
                    return entity.isSneaking();
    default:
        return true;
    }    
}
