function init(hero) {
    hero.setName("Martian Legian General");
    hero.setAliases("General Xen");
    hero.setTier(7);

    hero.setChestplate("Suit");
    hero.addPrimaryEquipment("fiskheroes:chronos_rifle", true);
    hero.addPrimaryEquipment("fiskheroes:ruptures_scythe", true);

    hero.addPowers("eden:martian_armor");
    hero.addAttribute("PUNCH_DAMAGE", 14.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 4.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 0.5, 0);
    hero.addAttribute("FALL_RESISTANCE", 7.0, 0);
    hero.addAttribute("IMPACT_DAMAGE", 0.3, 1);

    hero.addKeyBind("CHARGE_ENERGY", "key.chargeEnergy", 1);
    hero.addKeyBind("BLADE", "key.blade", 2);
    hero.addKeyBind("STEEL_TRANSFORM", "Armor Activate", 3);
    hero.addKeyBind("AIM", "key.aim", -1);

    hero.setHasPermission(hasPermission);
    hero.supplyFunction("canAim", canAim);
    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.addAttributeProfile("STEEL", steelProfile);
    hero.setTierOverride(getTierOverride);
    hero.setModifierEnabled(isModifierEnabled);
    hero.supplyFunction("canDischargeEnergy", isHoldingScythe);

    hero.addAttributeProfile("BLADE", bladeProfile);
    hero.setAttributeProfile(getProfile);
    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("BLADE", {
        "types": {
            "SHARP": 1.0,
            "ATLANTEAN_STEEL": 1.0
        }
    });

    hero.addSoundEvent("STEP", "fiskheroes:manta_walk");

    hero.setTickHandler((entity, manager) => {
        manager.incrementData(entity, "fiskheroes:dyn/booster_timer", 2, entity.getData("fiskheroes:flying"));
    });
}

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 9.5, 0);
}

function steelProfile(profile) {
    profile.addAttribute("PUNCH_DAMAGE", 9.0, 0);
    profile.addAttribute("JUMP_HEIGHT", 1.0, 0);
    profile.addAttribute("FALL_RESISTANCE", 5.0, 0);
    profile.addAttribute("SPRINT_SPEED", 0.15, 1);
}

function getTierOverride(entity) {
    return entity.getData("fiskheroes:dyn/steeled") ? 7 : 5;
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}

function isKeyBindEnabled(entity, keyBind) {
    return keyBind != "CHARGE_ENERGY" || isHoldingScythe(entity);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:dyn/steeled") ? "STEEL" : null;
}

function isModifierEnabled(entity, modifier) {
    return modifier.name() == "fiskheroes:transformation" || modifier.name() == "fiskheroes:cooldown" || entity.getData("fiskheroes:dyn/steeled") || modifier.name() != "fiskheroes:energy_manipulation" || isHoldingScythe(entity);
}

function hasPermission(entity, permission) {
    return permission == "USE_CHRONOS_RIFLE";
}

function canAim(entity) {
    return entity.getHeldItem().name() == "fiskheroes:chronos_rifle";
}

function isHoldingScythe(entity) {
    return entity.getHeldItem().name() == "fiskheroes:ruptures_scythe";
}