function init(hero) {
    hero.setName("Queen Mera");
    hero.setTier(4);
    
    hero.setChestplate("Suit");
    hero.addPrimaryEquipment("minecraft:water", true);

    hero.addPowers("eden:atlantean_hydrokenisis");
    hero.addAttribute("PUNCH_DAMAGE", 8, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.5, 0);
	hero.addAttribute("FALL_RESISTANCE", 40, 0);
    hero.addAttribute("SPRINT_SPEED", 1.15, 1);
    hero.addAttribute("STEP_HEIGHT", 0.5, 0);
   
    hero.addKeyBind("TENTACLE_JAB", "Tentacle Jab/ Toggle Shield", 3);
    hero.addKeyBind("TENTACLE_GRAB", "key.tentacleGrab", 5);
    hero.addKeyBind("TENTACLES", "Water Tentacles", 4);
    hero.addKeyBind("TELEKINESIS", "Hydrokinesis", 5);
	hero.addKeyBind("CHARGED_BEAM", "Hydro Cannon", 1);
    hero.addKeyBind("SPELL_MENU", "Atlantean Magic", 2);
    hero.addKeyBind("SHIELD", "key.shield", 3);
 
    hero.setModifierEnabled(isModifierEnabled);   
    hero.supplyFunction("canAim", canAim);
}

function canAim(entity) {
    return entity.getData("fiskheroes:shield") && entity.getData("fiskheroes:shield_blocking_timer") == 0;
}

function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
        case "fiskheroes:controlled_flight":
            return entity.isInWater();
    default:
        return true;
    }
}