var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Namor");
    hero.setTier(7);
 
    hero.setChestplate("Suit");
    
    hero.addPowers("eden:mutant_atlantean");
    hero.addAttribute("BASE_SPEED_LEVELS", 2.0, 0);
    hero.addAttribute("PUNCH_DAMAGE", 9.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 200, 0);

    hero.addKeyBind("INVISIBILITY", "key.invisibility", 1);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 2);
    hero.addKeyBind("SHIELD", "Trident", 3);
    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 4);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 5);
    
    hero.addAttributeProfile("TRIDENT", tridentProfile);
    hero.setAttributeProfile(getAttributeProfile);
    hero.setModifierEnabled(isModifierEnabled);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  


}

function tridentProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 11.5, 0);
    profile.addAttribute("STEP_HEIGHT", 0.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "TRIDENT" : null;
}

function canAim(entity) {
    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:grab_id") > -1;
}

function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
        case "fiskheroes:leaping":
            return entity.getData("fiskheroes:speeding");
    default:
        return true;
    }
}
