var utils = implement("fiskheroes:external/utils");

function init(hero) {
    hero.setName("Neptune");
    hero.setTier(10);
    

    hero.setHelmet("Helmet");
    hero.setChestplate("Chestpiece");
    hero.setLeggings("Pants");
    hero.setBoots("Boots");
    
    hero.addPowers("eden:ocean_olympian");
    hero.addAttribute("PUNCH_DAMAGE", 14.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.3, 1);
    hero.addAttribute("JUMP_HEIGHT", 2.5, 0);
    hero.addAttribute("FALL_RESISTANCE", 1.0, 1);
    hero.addAttribute("MAX_HEALTH", 19.5, 0); 

	hero.addKeyBind("CHARGED_BEAM", "Hydro Cannon", 1);
    hero.addKeyBind("SHIELD", "Trident", 2);	
    hero.addKeyBind("SHADOWFORM", "Water Form", 4);
    hero.addKeyBind("TELEKINESIS", "Hydrokinesis", 5);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 3);  

    hero.setHasProperty(hasProperty);
    hero.addAttributeProfile("TRIDENT", tridentProfile);
    hero.setAttributeProfile(getAttributeProfile);
	
}

function hasProperty(entity, property) {
    return property == "BREATHE_SPACE" 
}

function tridentProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 15.5, 0);
    profile.addAttribute("STEP_HEIGHT", 0.5, 0);
}

function canAim(entity) {
    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:grab_id") > -1;
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "TRIDENT" : null;
}
function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
        case "fiskheroes:controlled_flight":
            return entity.getData("fiskheroes:shadowform");
    default:
        return true;
    }
}