function init(hero) {
    hero.setName("Nightwing");
    hero.setAliases("Dick Greyson");
    hero.setTier(4);
    
    hero.setChestplate("Suit");
    hero.addPrimaryEquipment("fiskheroes:tactical_tonfa{Dual:1}", true, item => item.nbt().getBoolean("Dual"));
    hero.addPrimaryEquipment("fiskheroes:grappling_gun", true);

    hero.addPowers("eden:nightwing_suit");
    hero.addAttribute("PUNCH_DAMAGE", 6.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 3.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 1.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.2, 1);
    hero.addAttribute("IMPACT_DAMAGE", 0.5, 1);
    
    hero.addKeyBind("UTILITY_BELT", "key.utilityBelt", 2);
    hero.addKeyBind("WEB_ZIP", "Grapple Zip", 3);
    hero.addKeyBindFunc("func_WEB_SWINGING", webSwingingKey, "Grapple Swing", 4);
    hero.addKeyBind("SHIELD", "Baton", 1);
    hero.addKeyBind("BLADE", "Grappler", 4);
    hero.addKeyBind("CHARGE_ENERGY", "Charge Baton", 5);

    hero.setModifierEnabled(isModifierEnabled);  
    hero.setKeyBindEnabled(isKeyBindEnabled);

    hero.addAttributeProfile("BATON", batonProfile);

    hero.addAttributeProfile("GRAPPLER", grapplerProfile);
    
    hero.setHasPermission((entity, permission) => permission == "USE_GRAPPLING_GUN");
}

function batonProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 9.5, 0);
    profile.addAttribute("STEP_HEIGHT", 0.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "BATON" : null;
}

function grapplerProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 6.5, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "GRAPPLER" : null;
}

function webSwingingKey(player, manager) {
    var flag = player.getData("fiskheroes:web_swinging");

    if (!flag) {
        manager.setDataWithNotify(player, "fiskheroes:gliding", false);
    }

    manager.setDataWithNotify(player, "fiskheroes:web_swinging", !flag);
    return true;
}

function webWingsKey(player, manager) {
    if (player.isOnGround() || player.isInWater()) {
        return false;
    }

    var flag = player.getData("fiskheroes:gliding");

    if (!flag) {
        manager.setDataWithNotify(player, "fiskheroes:web_swinging", false);
    }

    manager.setDataWithNotify(player, "fiskheroes:gliding", !flag);
    return true;
}

function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
    case "fiskheroes:web_swinging":
        return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:utility_belt_type") == -1 && !entity.getData("fiskheroes:gliding");
    case "fiskheroes:web_zip":
        return !entity.getData("fiskheroes:gliding");
    case "fiskheroes:leaping":
        return modifier.id() == "springboard" == (entity.getData("fiskheroes:ticks_since_swinging") < 5);
    case "fiskheroes:gliding":
        return !entity.getData("fiskheroes:web_swinging") && entity.getData("fiskheroes:utility_belt_type") == -1 && !entity.as("PLAYER").isUsingItem();
    default:
        return true;
    }
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
    case "func_WEB_WINGS":
        return !entity.isOnGround() && !entity.isInWater() && !entity.as("PLAYER").isUsingItem();
    case "WEB_ZIP":
            return entity.getData("fiskheroes:blade")
    case "CHARGE_ENERGY":
            return entity.getData("fiskheroes:shield")
    default:
        return true;
    }
}