function init(hero) {
    hero.setName("Pack Hunter");
    hero.setTier(6);
    
    hero.setChestplate("Suit");

    hero.addPowers("eden:compi_mutation");

    hero.addAttribute("PUNCH_DAMAGE", 9.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 8.0, 0);
    hero.addAttribute("JUMP_HEIGHT", 1.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 7.0, 0);
    hero.addAttribute("IMPACT_DAMAGE", 0.3, 1);
    hero.addAttribute("SPRINT_SPEED", 1.7, 1);
  
    hero.addKeyBind("TENTACLE_GRAB", "Tail Grab", 2);
    hero.addKeyBind("TENTACLE_STRIKE", "Tail Strike", 3);
    hero.addKeyBind("TENTACLES", "Tail", 5);
    hero.addKeyBind("SPELL_MENU", "Clones", 4);
	
    hero.setKeyBindEnabled(isKeyBindEnabled);

    hero.setDefaultScale(0.7);
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
	case "TENTACLE_GRAB":
        return !entity.getData("fiskheroes:tentacles") == 0;
    case "TENTACLE_STRIKE":
        return !entity.getData("fiskheroes:tentacles") == 0;
	case "TENTACLE_JAB":
        return !entity.getData("fiskheroes:tentacles") == 0;
    default:
        return true;
    }
}