var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Parasus");
    hero.setTier(8);
    
    hero.setHelmet("Helmet");
    hero.setChestplate("Chestpiece");
    hero.setLeggings("Leggings");
    hero.setBoots("Boots");
	
    hero.addPowers("eden:torrenite_divinity", "eden:parasaur_mutation");
    hero.addAttribute("PUNCH_DAMAGE", 14.0, 0);
    hero.addAttribute("WEAPON_DAMAGE", 15.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 1);
	hero.addAttribute("MAX_HEALTH", 18.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 2.0, 0);

    hero.addKeyBind("CHARGED_BEAM", "Percussion Blast", 4);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 5); 
    hero.addKeyBind("SUPER_SPEED", "Torrenite Divinity", 1);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 2);
    hero.addKeyBind("ENERGY_PROJECTION", "Torrenite Beam", 5);
    hero.addKeyBind("SONIC_WAVES", "Percussion", 4);

    hero.setKeyBindEnabled(isKeyBindEnabled);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  

    hero.setHasProperty((entity, property) => property == "BREATHE_SPACE");

    } 
    function isKeyBindEnabled(entity, keyBind) {
        switch (keyBind) {
        case "GROUND_SMASH":
            return entity.isSneaking();
        case "ENERGY_PROJECTION":
            return entity.getData("fiskheroes:speeding") && entity.getHeldItem().isEmpty()
        default:
                return true;
            }
    }