var utils = implement("fiskheroes:external/utils");

function init(hero) {
    hero.setName("Raven");
    hero.setTier(9);

    hero.setChestplate("suit");

    hero.addPowers("eden:raven");
    hero.addAttribute("PUNCH_DAMAGE", 5.5, 0);
    hero.addAttribute("SPRINT_SPEED", 0.1, 1);
    hero.addAttribute("JUMP_HEIGHT", 1.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 40.0, 0);

    hero.addKeyBind("INTANGIBILITY", "Intagibility", 1);
    hero.addKeyBind("SPELL_MENU", "Spells", 2);
    hero.addKeyBind("TENTACLES", "Shadow Tentacles", 3);
    hero.addKeyBind("TENTACLE_JAB", "key.tentacleJab", 1);
    hero.addKeyBind("TENTACLE_GRAB", "key.tentacleGrab", 4);
    hero.addKeyBind("ENERGY_PROJECTION", "Beam", 5);
    hero.addKeyBind("AIM", "key.energyProjection", 5);

    hero.setDefaultScale(0.95);

    hero.setHasProperty((entity, property) => property == "BREATHE_SPACE");

    hero.setKeyBindEnabled(isKeyBindEnabled);

    hero.supplyFunction("canAim", canAim);

    hero.setTickHandler((entity, manager) => {
        utils.flightOnIntangibility(entity, manager);
    });
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
            case "INTANGIBILITY":
                return entity.isSneaking();
                case "ENERGY_PROJECTION":
                    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:beam_charge") == 0 && entity.getData("fiskheroes:aimed_timer") >= 1;
            case "AIM":
                return entity.getHeldItem().isEmpty();
    default:
            return true;
}
}

function canAim(entity) {
    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:beam_charge") == 0 && entity.getData('fiskheroes:time_since_damaged') > 1;
}