function init(hero) {
    hero.setName("Shazam");
    hero.setTier(5);

    hero.setChestplate("item.superhero_armor.piece.chestpiece");

    hero.addPowers("eden:shazam");
    hero.addAttribute("PUNCH_DAMAGE", 2.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 0.5, 0);
    hero.addAttribute("FALL_RESISTANCE", 500.0, 0);

    hero.addKeyBind("STEEL_TRANSFORM", "SHAZAM!", 1);
    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 2);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 3);
    hero.addKeyBind("TELEPORT", "SHAZAM!", 1);
    hero.addKeyBind("CHARGED_BEAM", "Lightning Blast", 4);
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 5); 

    hero.addAttributeProfile("STEEL", steelProfile);
    hero.setAttributeProfile(getAttributeProfile);
    hero.setModifierEnabled(isModifierEnabled);
    hero.setTierOverride(getTierOverride);
    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setDefaultScale(defaultScale);
}

function getTierOverride(entity) {
    return entity.getData("fiskheroes:dyn/steeled") ? 7 : 5;
}

function steelProfile(profile) {
    profile.addAttribute("PUNCH_DAMAGE", 13.3, 0);
    profile.addAttribute("JUMP_HEIGHT", 2.5, 0);
    profile.addAttribute("FALL_RESISTANCE", 1.0, 1);
    profile.addAttribute("IMPACT_DAMAGE", 0.15, 1);
    profile.addAttribute("BASE_SPEED_LEVELS", 6.0, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:dyn/steeled") ? "STEEL" : null;
}
function defaultScale(entity) {
    if (entity.getData('fiskheroes:dyn/steeled')) {
        return 1.0;
    }
    return 0.80;
}

function isModifierEnabled(entity, modifier) {
    return modifier.name() == "fiskheroes:transformation" || modifier.name() == "fiskheroes:cooldown" || entity.getData("fiskheroes:dyn/steeled");
}
function isModifierEnabled(entity, modifier) {
    if (modifier.name() == "fiskheroes:controlled_flight") {
        return (entity.getData("fiskheroes:dyn/steeled"));
    }
    else if (modifier.name() == "fiskheroes:fire_immunity") {
        return (entity.getData("fiskheroes:dyn/steeled"));
    }
    else if (modifier.name() == "fiskheroes:energy_projection") {
        return (entity.getData("fiskheroes:dyn/steeled"));
    }
    else if (modifier.name() == "fiskheroes:projectile_immunity") {
        return (entity.getData("fiskheroes:dyn/steeled"));
    }
    else if (modifier.name() == "fiskheroes:arrow_catching") {
        return (entity.getData("fiskheroes:dyn/steeled"));
    }
    else if (modifier.name() == "fiskheroes:super_speed") {
        return (entity.getData("fiskheroes:dyn/steeled"));
    }
    else if (modifier.name() == "fiskheroes:lightning_cast") {
        return (entity.getData("fiskheroes:dyn/steeled"));
    }
    return true;
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
    case "SUPER_SPEED":
        return (entity.getData("fiskheroes:dyn/steeled"));
    case "SLOW_MOTION":
        return (entity.getData("fiskheroes:dyn/steeled"));
    case "CHARGED_BEAM":
        return (entity.getData("fiskheroes:dyn/steeled"));
    case "GROUND_SMASH":
        return (entity.getData("fiskheroes:dyn/steeled"));
    default:
        return true;
    }    
}
