function init(hero) {
    hero.setName("Tempest/Garth");
    hero.setTier(4);
    
    hero.setChestplate("Suit");

    hero.addPowers("eden:atlantean_ancient_magic");
    hero.addAttribute("PUNCH_DAMAGE", 8, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.5, 0);
	hero.addAttribute("FALL_RESISTANCE", 40, 0);
    hero.addAttribute("SPRINT_SPEED", 1.15, 1);
    hero.addAttribute("STEP_HEIGHT", 0.5, 0);
   
    hero.addKeyBind("TENTACLE_JAB", "Shield/Tentacle Jab", 3);
    hero.addKeyBind("TENTACLE_GRAB", "key.tentacleGrab", 5);
    hero.addKeyBind("TELEKINESIS", "Hydrokinesis", 5);
    hero.addKeyBind("TENTACLES", "key.tentacles", 4);
    hero.addKeyBind("SHIELD", "key.shield", 3);
	hero.addKeyBind("CHARGED_BEAM", "Heat Vision", 2);
    hero.addKeyBind("ENERGY_PROJECTION", "Hydro Cannon", 1);
    hero.addKeyBind("SPELL_MENU", "Atlan's Magic", 1);
    
    hero.setModifierEnabled(isModifierEnabled);    
    hero.supplyFunction("canAim", canAim);

    hero.addAttributeProfile("BLADE", bladeProfile);
    hero.setAttributeProfile(getProfile);
    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("BLADE", {
        "types": {
            "SHARP": 1.0,
            "FIRE": 0.2
        }
    });
}

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 11.0, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}


function isModifierEnabled(entity, modifier) {
    return modifier.name() != "fiskheroes:shield" || !entity.getData("fiskheroes:blade");
}

function canAim(entity) {
    return entity.getData("fiskheroes:shield") && entity.getData("fiskheroes:shield_blocking_timer") == 0;
}

function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
        case "fiskheroes:controlled_flight":
            return entity.isInWater();
    default:
        return true;
    }
}