function init(hero) {
    hero.setName("The Atom");
    hero.setTier(6);

    hero.setChestplate("Suit");
    hero.addPrimaryEquipment("fiskheroes:rip_hunters_gun", true);

    hero.addPowers("eden:atom_suit");
    hero.addAttribute("PUNCH_DAMAGE", 5.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.15, 1);
    hero.addAttribute("JUMP_HEIGHT", 1.5, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 0);
    hero.addAttribute("STEP_HEIGHT", 0.5, 0);

    hero.addKeyBind("SIZE_MANIPULATION", "key.sizeManipulation", 1);
    hero.addKeyBind("MINIATURIZE_SUIT", "key.miniaturizeSuit", 3);
    hero.addKeyBind("AIM", "key.aim", -1);

    hero.setModifierEnabled(isModifierEnabled);
    hero.setHasProperty(hasProperty);
    hero.setHasPermission(hasPermission);
    hero.supplyFunction("canAim", canAim);

    hero.setTickHandler((entity, manager) => {
        manager.incrementData(entity, "fiskheroes:dyn/booster_timer", 2, entity.getData("fiskheroes:flying"));
        manager.incrementData(entity, "fiskheroes:dyn/shrink_timer", 3, entity.getData("fiskheroes:size_state") != 0);
    });
}

function isModifierEnabled(entity, modifier) {
    return modifier.name() != "fiskheroes:water_breathing" || entity.getData("fiskheroes:mask_open");
}

function hasProperty(entity, property) {
    return property == "MASK_TOGGLE" || property == "BREATHE_SPACE" && entity.getData("fiskheroes:mask_open");
}

function hasPermission(entity, permission) {
    return permission == "USE_RIPS_GUN";
}

function canAim(entity) {
    return entity.getHeldItem().name() == "fiskheroes:rip_hunters_gun";
}
