function init(hero) {
    hero.setName("The First Knight of the New Age");
    hero.setTier(6);
    
    hero.setChestplate("Suit");
    hero.addPrimaryEquipment("fiskheroes:captain_americas_shield{Electromagnetic:1,display:{Name:\"Knight's Shield\"}}", true);
    hero.addPrimaryEquipment("fiskheroes:chokuto{display:{Name:\"Knight's Sword\"}}", true, item => !item.nbt().getBoolean("Dual"));
    hero.addEquipment("fiskheroes:compound_bow");
    hero.addEquipment("fiskheroes:quiver");
    hero.addPrimaryEquipment("fiskheroes:grappling_gun", true);
    hero.addPrimaryEquipment("fiskheroes:beretta_93r{Dual:1}", true, item => item.nbt().getBoolean("Dual"));

    hero.addPowers("eden:knight_armor", "eden:operator");
	
    hero.addAttribute("PUNCH_DAMAGE", 6.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 3.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 1.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.2, 1);
    hero.addAttribute("IMPACT_DAMAGE", 0.5, 1);

    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBind("HORIZONTAL_BOW", "key.horizontalBow", 1);
    hero.addKeyBind("SHIELD_THROW", "key.shieldThrow", 1);
    hero.addKeyBind("GUN_RELOAD", "key.reload", 1);
    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBind("UTILITY_BELT", "key.utilityBelt", 2);

    hero.setHasPermission(hasPermission);
    hero.supplyFunction("canAim", canAim);

    hero.setKeyBindEnabled(isKeyBindEnabled);
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
    case "GUN_RELOAD":
        return entity.getHeldItem().isGun() && !entity.getData("fiskheroes:aiming");
    case "SHIELD_THROW":
        return entity.getHeldItem().name() == "fiskheroes:captain_americas_shield";
    case "HORIZONTAL_BOW":
        return entity.getHeldItem().name() == "fiskheroes:compound_bow";
    default:
        return true;
    }
}

function hasPermission(entity, permission) {
    return permission == "USE_GUN" || permission == "USE_SHIELD" || permission == "USE_GRAPPLING_GUN";
}

function canAim(entity) {
    return entity.getHeldItem().isGun();
}