function init(hero) {
    hero.setName("The Last Knight");
    hero.setTier(6);
    
    hero.setHelmet("item.superhero_armor.piece.helmet");
    hero.setChestplate("item.superhero_armor.piece.chestpiece");
    hero.setLeggings("item.superhero_armor.piece.pants");
    hero.setBoots("item.superhero_armor.piece.boots");
    hero.addPrimaryEquipment("fiskheroes:captain_americas_shield{Electromagnetic:1,display:{Name:\"Knight's Shield\"}}", true);
    hero.addPrimaryEquipment("fiskheroes:chokuto{display:{Name:\"Knight's Sword\"}}", true, item => !item.nbt().getBoolean("Dual"));
    hero.addEquipment("fiskheroes:compound_bow");
    hero.addEquipment("fiskheroes:quiver");
    hero.addPrimaryEquipment("fiskheroes:grappling_gun", true);
    hero.addPrimaryEquipment("fiskheroes:beretta_93r", true, item => !item.nbt().getBoolean("Dual"));

    hero.addPowers("eden:knight_armor", "eden:operator");
	
    hero.addAttribute("PUNCH_DAMAGE", 6.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 3.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 1.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 0);
    hero.addAttribute("SPRINT_SPEED", 0.2, 1);
    hero.addAttribute("IMPACT_DAMAGE", 0.5, 1);

    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBind("HORIZONTAL_BOW", "key.horizontalBow", 1);
    hero.addKeyBind("SHIELD_THROW", "key.shieldThrow", 1);
    hero.addKeyBind("GUN_RELOAD", "key.reload", 1);
    hero.addKeyBind("AIM", "key.aim", -1);
    hero.addKeyBind("UTILITY_BELT", "key.utilityBelt", 2);
    hero.addKeyBind("SHIELD", "Sword", 3);

    hero.setHasPermission(hasPermission);
    hero.supplyFunction("canAim", canAim);

    hero.addAttributeProfile("BRACELET", braceletProfile);

    hero.setKeyBindEnabled(isKeyBindEnabled);
}

function braceletProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 9.5, 0);
    profile.addAttribute("STEP_HEIGHT", 0.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "BRACELET" : null;
}

function canAim(entity) {
    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:grab_id") > -1;
}

function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
    case "GUN_RELOAD":
        return entity.getHeldItem().isGun() && !entity.getData("fiskheroes:aiming");
    case "SHIELD_THROW":
        return entity.getHeldItem().name() == "fiskheroes:captain_americas_shield";
    case "HORIZONTAL_BOW":
        return entity.getHeldItem().name() == "fiskheroes:compound_bow";
    default:
        return true;
    }
}

function hasPermission(entity, permission) {
    return permission == "USE_GUN" || permission == "USE_SHIELD" || permission == "USE_GRAPPLING_GUN";
}

function canAim(entity) {
    return entity.getHeldItem().isGun();
}