var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Thunderbird");
    hero.setVersion("Dino -Squad");
    hero.setTier(8);
    
    hero.setHelmet("Helmet");
    hero.setChestplate("Chestpiece");
    hero.setLeggings("Leggings");
    hero.setBoots("Boots");
	
    hero.addPowers("eden:pteradon_mutation");
    hero.addAttribute("PUNCH_DAMAGE", 12.0, 0);
    hero.addAttribute("WEAPON_DAMAGE", 12.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 300.0, 0);
	hero.addAttribute("MAX_HEALTH", 18.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 1.0, 0);

    hero.addKeyBind("CHARGED_BEAM", "Lightning Blast", 3);
    hero.addKeyBind("SUPER_SPEED", "Thunderbird Magic", 1);
    hero.addKeyBind("SLOW_MOTION", "Hightened Perception", 2);
    hero.addKeyBind("SHIELD", "Staff", 4);

    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.setModifierEnabled(isModifierEnabled);

    hero.addAttributeProfile("STAFF", staffProfile);
    hero.setAttributeProfile(getAttributeProfile);
    
    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  
    } 
    function staffProfile(profile) {
        profile.inheritDefaults();
        profile.addAttribute("PUNCH_DAMAGE", 12.5, 0);
        profile.addAttribute("STEP_HEIGHT", 0.5, 0);
    }
    
    function getAttributeProfile(entity) {
        return entity.getData("fiskheroes:shield") ? "STAFF" : null;
    }
    
    function canAim(entity) {
        return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:grab_id") > -1;
    }

    function isKeyBindEnabled(entity, keyBind) {
        switch (keyBind) {
                case "CHARGED_BEAM":
                    return entity.getData("fiskheroes:shield") 
        default:
                return true;
    }
    }
function isModifierEnabled(entity, modifier) {
    if (modifier.name() == "fiskheroes:speeding") {
        return entity.getData("fiskheroes:controlled_flight");
    }
    if (modifier.name() == "fiskheroes:lightning_cast") {
        return entity.getData("fiskheroes:speeding");
    }
    return true;
}