function init(hero) {
    hero.setName("Trike");
    hero.setVersion("Dino-Squad");
    hero.setTier(5);

    hero.setHelmet("item.superhero_armor.piece.helmet");
    hero.setChestplate("item.superhero_armor.piece.chestplate");
    hero.setLeggings("item.superhero_armor.piece.leggings");
    hero.setBoots("item.superhero_armor.piece.boots");

    hero.addPowers("eden:triceratops_mutation");
    hero.addAttribute("PUNCH_DAMAGE", 13.5, 0);
    hero.addAttribute("WEAPON_DAMAGE", 2.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.5, 0);
    hero.addAttribute("FALL_RESISTANCE", 400.0, 0);
    hero.addAttribute("SPRINT_SPEED", 1.3, 1);
    hero.addAttribute("MAX_HEALTH", 15.5, 0); 

    hero.addKeyBind("SHIELD", "key.shield", 1);
    hero.addKeyBind("EARTHQUAKE", "Stampede", 2);
    hero.addKeyBind("GROUND_SMASH", "key.groundSmash", 3);
    hero.addKeyBind("SPELL_MENU", "Charge", 4);


    hero.setDefaultScale(1.2);
    hero.setKeyBindEnabled(isKeyBindEnabled);
    hero.addAttributeProfile("SHIELD", shieldProfile);
    hero.setAttributeProfile(getProfile);
    hero.setDamageProfile(getProfile);
    hero.addDamageProfile("SHIELD", {
        "types": {
            "BLUNT": 0.7,
            "SHARP": 0.3
        }
    });
}

function shieldProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 9.5, 0);
    profile.addAttribute("SPRINT_SPEED", 2.3, 1);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "SHIELD" : null;
}
function isKeyBindEnabled(entity, keyBind) {
    switch (keyBind) {
            case "SPELL_MENU":
                return entity.getData("fiskheroes:shield") 
    default:
            return true;
}
}