var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Donna Troy");
    hero.setTier(7);
 
    hero.setChestplate("Suit");

    hero.addPrimaryEquipment("fiskheroes:captain_americas_shield{Electromagnetic:1,display:{Name:\"Amazonian Shield\"}}", true);
    
    hero.addPowers("eden:amazonian_physiology");
    hero.addAttribute("BASE_SPEED_LEVELS", 2.0, 0);
    hero.addAttribute("PUNCH_DAMAGE", 8.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 300, 0);
    
    hero.addKeyBind("GROUND_SMASH", "Ground Smash", 3);
    hero.addKeyBind("BLADE", "Blade", 1);
    hero.addKeyBind("SHIELD", "Battle Stance", 2);
    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 4);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 5);
    
    hero.addAttributeProfile("BLADE", bladeProfile);
    hero.addAttributeProfile("BRACELET", braceletProfile);
    hero.setModifierEnabled(isModifierEnabled);

    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  

    hero.setHasPermission(hasPermission);


}

function hasPermission(entity, permission) {
    return  permission == "USE_SHIELD";
}

function bladeProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 8.5, 0);
}

function getProfile(entity) {
    return entity.getData("fiskheroes:blade") ? "BLADE" : null;
}

function braceletProfile(profile) {
    profile.inheritDefaults();
    profile.addAttribute("PUNCH_DAMAGE", 9.5, 0);
    profile.addAttribute("STEP_HEIGHT", 0.5, 0);
}

function getAttributeProfile(entity) {
    return entity.getData("fiskheroes:shield") ? "BRACELET" : null;
}

function canAim(entity) {
    return entity.getHeldItem().isEmpty() && entity.getData("fiskheroes:grab_id") > -1;
}

function isModifierEnabled(entity, modifier) {
    switch (modifier.name()) {
        case "fiskheroes:leaping":
            return entity.getData("fiskheroes:speeding");
    default:
        return true;
    }
}

