var speedster_base = implement("fiskheroes:external/speedster_base");

function init(hero) {
    hero.setName("Zeus");
    hero.setTier(8);
    
    hero.setChestplate("Suit");
	
    hero.addPowers("eden:pteradon_mutation");
    hero.addAttribute("PUNCH_DAMAGE", 12.0, 0);
    hero.addAttribute("WEAPON_DAMAGE", 12.5, 0);
    hero.addAttribute("JUMP_HEIGHT", 2.0, 0);
    hero.addAttribute("FALL_RESISTANCE", 20.0, 1);
	hero.addAttribute("MAX_HEALTH", 18.0, 0);
    hero.addAttribute("BASE_SPEED_LEVELS", 3.0, 0);

    hero.addKeyBind("CHARGED_BEAM", "Lightning Blast", 3);
    hero.addKeyBind("SUPER_SPEED", "key.superSpeed", 1);
    hero.addKeyBind("SLOW_MOTION", "key.slowMotion", 2);
    hero.addKeyBind("CHARGE_ENERGY", "Lightning Rod", 4);

    hero.supplyFunction("canDischargeEnergy", isHoldingStaff);
    hero.setKeyBindEnabled(isKeyBindEnabled);
    
    hero.addSoundOverrides("BARRY", speedster_base.mergeSounds("fiskheroes:speed_force", speedster_base.SOUNDS_BARRY));

    hero.setTickHandler((entity, manager) => {
        speedster_base.tick(entity, manager);
    });  
    } 

    function isKeyBindEnabled(entity, keyBind) {
        return keyBind != "CHARGE_ENERGY" || isHoldingStaff(entity);
    }

function isHoldingStaff(entity) {
    return entity.getHeldItem().name() == "fiskheroes:bo_staff";
}