extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:ace_layer1",
    "layer2": "eden:ace_layer2",
    "cape": "eden:ace_cape",

    "rope": "eden:ace_rope",
    "grapple": "eden:ace_rope_grappler",
    "grappler": "eden:batman_grappler"
});

var capes = implement("fiskheroes:external/capes");

var cape;

function initEffects(renderer) {
    
    var webs = renderer.bindProperty("fiskheroes:webs");
    webs.textureRope.set("rope");
    webs.textureRopeBase.set("grapple");

    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.maxFlare = 0.4;
    physics.flareDegree = 1.5;
    physics.flareFactor = 1.2;
    physics.flareElasticity = 5;

    cape = capes.createGlider(renderer, 24, "fiskheroes:cape_batman.mesh.json", physics);
    cape.effect.texture.set("cape");

    var model_grappler = renderer.createResource("MODEL", "eden:grappler");
    model_grappler.texture.set("grappler");
    grappler = renderer.createEffect("fiskheroes:model").setModel(model_grappler);
    grappler.anchor.set("rightArm");
    grappler.setScale(2);

    renderer.bindProperty("fiskheroes:equipment_wheel").color.set(0x000000);
    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "leftLeg", "scale": 0.7, "offset": [2.4, 0.5, 1.25], "rotation": [90.0, 0.0, 0.0] }
    ]).slotIndex = 0;
    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "rightLeg", "scale": 0.7, "offset": [-2.4, 0.5, 1.25], "rotation": [90.0, 0.0, 0.0] }
    ]).slotIndex = 2;
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        cape.render(entity, entity.getInterpolatedData("fiskheroes:wing_animation_timer"));
    }
    if (renderLayer == "CHESTPLATE") {
        if (entity.getData("fiskheroes:blade_timer") > 0.9) {
            var blade_anchor = grappler.anchor.set("rightArm");
            var blade_offSet = grappler.setOffset(-2.4, 16.8, 17.3);
            var blade_rot = grappler.setRotation(55, -75, -25);
            

			
            grappler.anchor = blade_anchor, blade_offSet, blade_rot;
            grappler.render();
        }


}
}