extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:angel_layer1",
    "layer2": "eden:angel_layer2",
    "wings": "eden:angel_wings",
    "wings_back": "eden:angel_back_wings"
});

var utils = implement("fiskheroes:external/utils");
var wing_utils = implement("fiskheroes:external/wing_utils");

var wings;

var wings_back;

function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    wings = wing_utils.create(renderer, "wings", null, wing_utils.PRESET_CONTROLLED_FLIGHT);

    utils.addCameraShake(renderer, 0.015, 0.75, "fiskheroes:flight_boost_timer");
    utils.addCameraShake(renderer, 0.015, 0.75, "fiskheroes:dyn/flight_super_boost_timer");
    var shake = renderer.bindProperty("fiskheroes:camera_shake").setCondition(entity => {
        shake.factor = entity.isSprinting() && entity.getData("fiskheroes:flying") ? 0.15 * Math.sin(Math.PI * entity.getInterpolatedData("fiskheroes:flight_boost_timer")) : 0;

        if (entity.getData("fiskheroes:dyn/flight_super_boost") > 0) {
            shake.factor += 0.15 * Math.sin(Math.PI * entity.getInterpolatedData("fiskheroes:dyn/flight_super_boost_timer"));
        }
        return true;
    });
    shake.intensity = 0.05;

    wings_back = renderer.createEffect("fiskheroes:model");
    wings_back.setModel(utils.createModel(renderer, "eden:wings", "wings_back", null));
    wings_back.anchor.set("rightArm");
    wings_back.mirror = false;
    wings_back.setScale(1.2);

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addHoverAnimation(renderer, "falcon.HOVER", "fiskheroes:flight/idle/falcon");
    utils.addFlightAnimation(renderer, "falcon.FLIGHT", getFlightAnimation(), (entity, data) => {
        data.load(0, entity.getInterpolatedData("fiskheroes:flight_timer"));
        data.load(1, entity.getInterpolatedData("fiskheroes:flight_boost_timer"));
        data.load(3, entity.getInterpolatedData("fiskheroes:dyn/flight_super_boost_timer"));
    });

    renderer.reprioritizeDefaultAnimation("RELOAD_GUN", -9);

    utils.addAnimationEvent(renderer, "FLIGHT_DIVE", "fiskheroes:iron_man_dive");
    utils.addAnimationEvent(renderer, "FLIGHT_DIVE_ROLL", "fiskheroes:falcon_dive_roll");

    addAnimationWithData(renderer, "falcon.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;
}

function getFlightAnimation() {
    return "fiskheroes:flight/falcon.anim.json";
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        wings.render(entity, entity.getInterpolatedData("fiskheroes:shield_blocking_timer"));

    }
    if (renderLayer == "CHESTPLATE") {

        wings_back.opacity = entity.getData("fiskheroes:flight_timer") < 1;
        wings_back.render();
    
        var blade_anchor = wings_back.anchor.set("body");
        var blade_offSet = wings_back.setOffset(-1.0, 4.6, -0.5);
        var blade_rot = wings_back.setRotation(0, 0, 0);
        wings_back.anchor = blade_anchor, blade_offSet, blade_rot;
    }
}