extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:aquaman_layer1",
    "layer2": "eden:aquaman_layer2",
    "trident": "eden:trident"
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var trident_dceu;
var trident_dceu_back;
function init(renderer) {
    parent.init(renderer);

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    speedster.init(renderer, "eden:aquaman_blur");

    trident_dceu = renderer.createEffect("fiskheroes:model");
    trident_dceu.setModel(utils.createModel(renderer, "eden:trident_dceu", "trident", null));
    trident_dceu.anchor.set("rightArm");
    trident_dceu.mirror = false;

    trident_dceu_back = renderer.createEffect("fiskheroes:model");
    trident_dceu_back.setModel(utils.createModel(renderer, "eden:trident_dceu_back", "trident", null));
    trident_dceu_back.anchor.set("body");
    trident_dceu_back.mirror = false;

    var color = 0x0049FF;

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(color);
    magic.colorEarthCrack.set(color);
    magic.colorAtmosphere.set(color);
    magic.colorWhip.set(color);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addFlightAnimation(renderer, "shazam.FLIGHT", "fiskheroes:flight/default.anim.json");
    utils.addHoverAnimation(renderer, "shazam.HOVER", "fiskheroes:flight/idle/default");

    addAnimationWithData(renderer, "iron_man.LAND", "fiskheroes:superhero_landing", "fiskheroes:dyn/superhero_landing_timer")
        .priority = -8;

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        trident_dceu.opacity = entity.getData("fiskheroes:shield");
        trident_dceu.render();

        var blade_anchor = trident_dceu.anchor.set("rightArm");
        var blade_offSet = trident_dceu.setOffset(0.8, 7.8, 5.3);
        var blade_rot = trident_dceu.setRotation(90, 0, 0);
        trident_dceu.anchor = blade_anchor, blade_offSet, blade_rot;

        trident_dceu_back.opacity = entity.getData("fiskheroes:shield") < 1;
        trident_dceu_back.render();

        var blade_anchor = trident_dceu_back.anchor.set("body");
        var blade_offSet = trident_dceu_back.setOffset(2.8, 3.6, 2.3);
        var blade_rot = trident_dceu_back.setRotation(0, 0, 0);
        trident_dceu_back.anchor = blade_anchor, blade_offSet, blade_rot;

    }
       }


