extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:aquaman_harpoon_layer1",
    "layer2": "eden:aquaman_harpoon_layer2",
    "harpoon": "eden:trident",

    "rope": "eden:aquaman_rope",
    "grapple": "eden:aquaman_rope_tip"
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var harpoon;

var harpoon_active;

function init(renderer) {
    parent.init(renderer);

    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    var webs = renderer.bindProperty("fiskheroes:webs");
    webs.textureRope.set("rope");
    webs.textureRopeBase.set("tip");

    harpoon = renderer.createEffect("fiskheroes:model");
    harpoon.setModel(utils.createModel(renderer, "eden:harpoon", "harpoon"));
    harpoon.anchor.set("rightArm");
    harpoon.mirror = false;

    harpoon_active = renderer.createEffect("fiskheroes:model");
    harpoon_active.setModel(utils.createModel(renderer, "eden:harpoon_active", "harpoon"));
    harpoon_active.anchor.set("rightArm");
    harpoon_active.mirror = false;

    var color = 0xFFFF55;

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(color);
    magic.colorEarthCrack.set(color);
    magic.colorAtmosphere.set(color);
    magic.colorWhip.set(color);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addFlightAnimation(renderer, "shazam.FLIGHT", "fiskheroes:flight/default.anim.json");
    utils.addHoverAnimation(renderer, "shazam.HOVER", "fiskheroes:flight/idle/default");

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

    addAnimationWithData(renderer, "harpoon.SWORD_POSE", "fiskheroes:sword_pose", "fiskheroes:blade_timer");
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        harpoon.render();

        var blade_anchor = harpoon.anchor.set("rightArm");
        var blade_offSet = harpoon.setOffset(1.6, -1.3, -1.0);
        var blade_rot = harpoon.setRotation(90, 90, 90);
        harpoon.anchor = blade_anchor, blade_offSet, blade_rot;
    }
    if (renderLayer == "CHESTPLATE") {
        if (entity.getData("fiskheroes:blade_timer") > 0.9) {
            var blade_anchor = harpoon_active.anchor.set("rightArm");
            var blade_offSet = harpoon_active.setOffset(1.6, -1.3, -1.0);
            var blade_rot = harpoon_active.setRotation(90, 90, 90);
            

			
            harpoon_active.anchor = blade_anchor, blade_offSet, blade_rot;
            harpoon_active.render();
        }


}
}


