extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:batman_zero_year_layer1",
    "layer2": "eden:batman_zero_year_layer2",
    "arrow": "fiskheroes:arrow/prometheus",
    "quiver": "fiskheroes:quiver/prometheus",
    "spikes": "eden:batman_spikes",
    "ears": "eden:batman_ears",
});

var utils = implement("fiskheroes:external/utils");

var sheath;

function init(renderer) {
    parent.init(renderer);
	
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    utils.addLivery(renderer, "ARROW", "arrow");
    utils.addLivery(renderer, "QUIVER", "quiver");

    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "body", "scale": 0.7, "offset": [-4.5, 10.5, 0.4], "rotation": [110.0, 5.0, 0.0] }
    ]);

    shield = renderer.createEffect("fiskheroes:shield");
    shield.texture.set("spikes");
    shield.anchor.set("rightArm");
    shield.setCurve(25.0, 35.0);

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = true;

    var model = renderer.createResource("MODEL", "eden:ears");
    model.texture.set("ears");
    ears = renderer.createEffect("fiskheroes:model").setModel(model);
    ears.anchor.set("head");
}
function render(entity, renderLayer, isFirstPersonArm) {

    if (!isFirstPersonArm) {
        if (renderLayer == "CHESTPLATE") {
            ears.render();
        }
    }
    if (renderLayer == "CHESTPLATE") {
        shield.unfold = entity.getInterpolatedData("fiskheroes:shield_timer");
        shield.setOffset(2.9 + 1.35 * Math.min(shield.unfold * 5, 1), 5.0, 0.0);
        shield.render();
    }

}
