extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:behemoth_layer1",
    "layer2": "eden:behemoth_layer2",
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");


function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
}

function initEffects(renderer) {
    
    speedster.init(renderer, "eden:behemoth");

}
function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");
    
	addAnimationWithData(renderer, "basic.AIMING", "fiskheroes:dual_aiming", "fiskheroes:beam_charge");
    utils.addFlightAnimation(renderer, "basic.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "basic.HOVER", "fiskheroes:flight/idle/propelled_hands");

    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");

}