extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:bolt_layer1",
    "layer2": "eden:bolt_layer2",
    "scepter": "eden:trident"
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var ears;

var scepter;

function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {
    
    speedster.init(renderer, "fiskheroes:lightning_comics_yellow");

    ears = renderer.createEffect("fiskheroes:ears");
    ears.anchor.set("head");
    ears.angle = 20;
    ears.inset = 0.075;

    vibration = renderer.createEffect("fiskheroes:vibration");

    hermes_scepter = renderer.createEffect("fiskheroes:model");
    hermes_scepter.setModel(utils.createModel(renderer, "eden:hermes_scepter", "scepter", null));
    hermes_scepter.anchor.set("rightArm");
    hermes_scepter.mirror = false;

    // Antimatter Beam
    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:lightning_cast", "body", 0xE0FFFF, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_energy_projection"));

    // Antimatter Blast
    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:lightning_cast", "rightArm", 0xE0FFFF, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
        { "firstPerson": [4.5, 3.75, -8.0], "offset": [0.5, 9.0, 0.0], "size": [3.0, 3.0], "anchor": "leftArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

    utils.bindBeam(renderer, "fiskheroes:lightning_cast", "fiskheroes:energy_discharge", "rightArm", 0xE0FFFF, [
        { "firstPerson": [-8.0, 4.5, -10.0], "offset": [-0.5, 9.0, 0.0], "size": [0.75, 0.75] }
    ]);	
    utils.bindBeam(renderer, "fiskheroes:energy_manipulation", "fiskheroes:energy_discharge", "rightArm", 0xE0FFFF, [
        { "firstPerson": [-2.5, 0.0, -7.0], "offset": [-0.5, 19.0, -12.0], "size": [1.5, 1.5] }
    ]);

    renderer.bindProperty("fiskheroes:energy_bolt").color.set(0xE0FFFF);
    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "body", "scale": 0.7, "offset": [-3.5, 2.0, 3.0], "rotation": [0.0, -90.0, 60.0] }
    ]).addOffset("QUIVER", 0.0, 0.0, 3.0);
}
function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");
}
function render(entity, renderLayer, isFirstPersonArm) {
    if (!isFirstPersonArm && renderLayer == "HELMET") {
        ears.render();
    }
    if (!entity.isDisplayStand() && entity.getData("fiskheroes:intangibility_timer")) {
        vibration.render();
        }
        if (renderLayer == "CHESTPLATE") {
            hermes_scepter.opacity = entity.getData("fiskheroes:shield");
            hermes_scepter.render();
    
            var blade_anchor = hermes_scepter.anchor.set("rightArm");
            var blade_offSet = hermes_scepter.setOffset(-0.5, 9.8, -7.3);
            var blade_rot = hermes_scepter.setRotation(90, 0, 0);
            hermes_scepter.anchor = blade_anchor, blade_offSet, blade_rot;
    
        }
}