extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:emperor_layer1",
    "layer2": "eden:emperor_layer2",
    "shield": "eden:penguin_shield",
    "cape": "eden:emperor_cape",
    "ice_breathe": "eden:ice_breathe",
});

var speedster = implement("fiskheroes:external/speedster_utils");

var capes = implement("fiskheroes:external/capes");

var utils = implement("fiskheroes:external/utils");

var cape;

var ice_breathe;

function initEffects(renderer) {

    speedster.init(renderer, "eden:emperor_blur");

    var physics = renderer.createResource("CAPE_PHYSICS", null);
    physics.maxFlare = 0.4;
    cape = capes.createDefault(renderer, 17, "fiskheroes:cape_default.mesh.json", physics);
    cape.effect.texture.set("cape");
    cape.effect.width = 10;

    shield = renderer.createEffect("fiskheroes:shield");
    shield.texture.set("shield");
    shield.anchor.set("rightArm");
    shield.setCurve(25.0, 35.0);

    ice_breathe = renderer.createEffect("fiskheroes:overlay");
    ice_breathe.texture.set(null, "ice_breathe");

    utils.bindParticles(renderer, "eden:iceman_trail").setCondition(entity => entity.getData("fiskheroes:speeding"));

    var beam = renderer.createResource("BEAM_RENDERER", "fiskheroes:mysterio_beam");
    utils.bindBeam(renderer, "fiskheroes:charged_beam", beam, "head", 0x4CB5FF, [
        { "firstPerson": [0.0, 4.0, 0.0], "offset": [0.0, -1.4, 0.0], "size": [3.0, 3.0] }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "eden:impact_ice"));
}
function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        shield.unfold = entity.getInterpolatedData("fiskheroes:shield_timer");
        shield.setOffset(2.9 + 1.35 * Math.min(shield.unfold * 5, 1), 5.0, 0.0);
        shield.render();
    }

    if (!isFirstPersonArm && renderLayer == "CHESTPLATE") {
        cape.render(entity);
    }
    if (renderLayer == "HELMET") {
        ice_breathe.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        ice_breathe.render();
    }
}