extend("fiskheroes:hero_basic");
loadTextures({
	"layer1": "eden:gambit_layer1",
	"layer2": "eden:gambit_layer2",
    "cards": "eden:gambit_cards"
});

var utils = implement("fiskheroes:external/utils");

var gambit_cards;

function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    utils.bindBeam(renderer, "fiskheroes:energy_manipulation", "fiskheroes:energy_discharge", "rightArm", 0x9400d3, [
        { "firstPerson": [-2.5, 0.0, -7.0], "offset": [-0.5, 19.0, -12.0], "size": [1.5, 1.5] }
    ]);
    
    utils.bindBeam(renderer, "fiskheroes:lightning_cast", "fiskheroes:energy_discharge", "rightArm", 0xB416FF, [
        { "firstPerson": [-8.0, 4.5, -10.0], "offset": [-0.5, 9.0, 0.0], "size": [0.75, 0.75] }
    ]);

    renderer.bindProperty("fiskheroes:equipped_item").setItems([
        { "anchor": "body", "scale": 0.55, "offset": [0.5, 4.5, 3.0], "rotation": [0.0, -90.0, 35.0] }
    ]);

    gambit_cards = renderer.createEffect("fiskheroes:model");
    gambit_cards.setModel(utils.createModel(renderer, "eden:gambit_cards", "cards", "lights", null));
    gambit_cards.anchor.set("rightArm");
    gambit_cards.setScale(1);
}
function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        if (entity.getData("fiskheroes:blade_timer") > 0.9) {
            var blade_anchor = gambit_cards.anchor.set("rightArm");
            var blade_offSet = gambit_cards.setOffset(0.6, 8.8, -4.1);
            var blade_rot = gambit_cards.setRotation(90, 0, 0);
            

			
            gambit_cards.anchor = blade_anchor, blade_offSet, blade_rot;
            gambit_cards.render();
        }


}

}

