extend("fiskheroes:hero_basic");
loadTextures({
    "sword": "eden:green_lantern_sword",
    "layer1": "eden:green_lantern_hal_layer1",
    "layer2": "eden:green_lantern_hal_layer2",

    "segment": "eden:green_lantern_arm",
    "claw": "eden:green_lantern_claw",

    "aura" : "eden:green_lantern_light",
    "gun" : "eden:green_lantern_sword",
    "rope": "eden:green_lantern_rope",
    "large": "eden:green_lantern_web",
    "grapple": "eden:green_lantern_rope_grappler",
    "lights_big": "eden:green_lantern_big",
    "lights": "eden:green_lantern_ring",
    "pistol": "eden:green_lantern_sword",
    "scythe" : "eden:green_lantern_sword",
    "jackhammer" : "eden:green_lantern_sword",
    "wall" : "eden:green_lantern_sword",

});

var utils = implement("fiskheroes:external/utils");

var aura;

var jackhammer;

var brick_wall;

function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
    renderer.setLights((entity, renderLayer) => {
        if (renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || renderLayer == "CHESTPLATE")

        return entity.getData("fiskheroes:dyn/giant_mode") ? "lights_big" : "lights";
    });
}

function initEffects(renderer) {
    utils.addLivery(renderer, "CHOKUTO", "sword");

    utils.addLivery(renderer, "CHRONOS_RIFLE", "gun");

    utils.addLivery(renderer, "RUPTURES_SCYTHE", "scythe");

    utils.addLivery(renderer, "RIPS_GUN", "pistol");

    var webs = renderer.bindProperty("fiskheroes:webs");
    webs.textureRope.set("rope");
    webs.textureSmall.set("grapple");
    webs.textureRopeBase.set("grapple");
    webs.textureLarge.set("large");

    var oct_arm = utils.createModel(renderer, "eden:oct_arm", "segment");
    var oct_tip = utils.createModel(renderer, "eden:oct_tip", "claw");
    oct_tip.bindAnimation("eden:ock_claw").setData((entity, data) => {
        var t = entity.as("TENTACLE");
        data.load(0, 1 - Math.min(t.getCaster().getInterpolatedData("fiskheroes:tentacle_extend_timer") * 2, 1));
        data.load(1, t.getIndex());
        data.load(2, t.getGrabTimer());
        data.load(3, t.getStrikeTimer());
    });

    var tentacles = renderer.bindProperty("fiskheroes:tentacles").setTentacles([
        { "offset": [2.0, -4.5, -2.0], "direction": [13.0, 10.0, -10.0] },
        { "offset": [-2.0, -4.5, -2.0], "direction": [-13.0, 10.0, -10.0] },
        { "offset": [2.0, -7.5, -2.0], "direction": [13.0, -10.0, -10.0] },
        { "offset": [-2.0, -7.5, -2.0], "direction": [-13.0, -10.0, -10.0] },
        { "offset": [2.0, -12.0, 0.0], "direction": [25.0, -12.0, 0.0]},
        { "offset": [-2.0, -12.0, 0.0], "direction": [-25.0, -12.0, 0.0]}
    ]);
    tentacles.anchor.set("body");
    tentacles.setSegmentModel(oct_arm);
    tentacles.setHeadModel(oct_tip);
    tentacles.segmentLength = 5.5;
    tentacles.segments = 20;

    utils.bindCloud(renderer, "fiskheroes:telekinesis", "eden:green_breach");

    renderer.bindProperty("fiskheroes:energy_bolt").color.set(0x55FF55);

    aura = renderer.createEffect("fiskheroes:overlay");
    aura.texture.set(null, "aura");

    var magic = renderer.bindProperty("fiskheroes:spellcasting");
    magic.colorGeneric.set(0x55FF55);
    magic.colorEarthCrack.set(0x55FF55);
    magic.colorAtmosphere.set(0x55FF55);
    magic.colorWhip.set(0x55FF55);

    jackhammer = renderer.createEffect("fiskheroes:model");
    jackhammer.setModel(utils.createModel(renderer, "eden:jackhammer", "jackhammer", null));
    jackhammer.anchor.ignoreAnchor(true);
    jackhammer.setScale(2);

    brick_wall = renderer.createEffect("fiskheroes:model");
    brick_wall.setModel(utils.createModel(renderer, "eden:brick_wall", "wall", null));
    brick_wall.anchor.ignoreAnchor(true);
    brick_wall.setScale(2);

    renderer.bindProperty("fiskheroes:equipment_wheel").color.set(0x55FF55);

    utils.bindBeam(renderer, "fiskheroes:energy_projection", "fiskheroes:energy_projection", "body", 0x55FF55, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_energy_projection"));

    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:energy_projection", "rightArm", 0x55FF55, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" }
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    renderer.removeCustomAnimation("basic.CHARGED_BEAM");
    
	addAnimationWithData(renderer, "basic.AIMING", "fiskheroes:dual_aiming", "fiskheroes:beam_charge");
    utils.addFlightAnimation(renderer, "basic.FLIGHT", "fiskheroes:flight/propelled_hands.anim.json");
    utils.addHoverAnimation(renderer, "basic.HOVER", "fiskheroes:flight/idle/propelled_hands");

    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");

    addAnimationWithData(renderer, "iron_man.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
    .priority = 10;

    renderer.removeCustomAnimation("basic.BLOCKING");
    addAnimationWithData(renderer, "basic.BLOCKING", "fiskheroes:dual_aiming", "fiskheroes:shield_blocking_timer")
    .priority = -5;
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:beam_charge");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:energy_projection_timer");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:flight_timer");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:shield_blocking_timer");
        aura.render();
    }
    if (renderLayer ==  "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        aura.opacity = entity.getInterpolatedData("fiskheroes:tentacle_extend_timer");
        aura.render();
    }
    if (renderLayer == "CHESTPLATE") {
        if (entity.getData("fiskheroes:blade_timer") > 0.9) {
            var blade_anchor = jackhammer.anchor.set("rightArm");
            var blade_offSet = jackhammer.setOffset(-2.0, -2, -50);
            var blade_rot = jackhammer.setRotation(-90, 90, 90);
            

			
            jackhammer.anchor = blade_anchor, blade_offSet, blade_rot;
            jackhammer.render();
        }


}
if (renderLayer == "CHESTPLATE") {
    brick_wall.opacity = entity.getData("fiskheroes:shield_blocking_timer");
    brick_wall.render();

    var blade_anchor = brick_wall.anchor.ignoreAnchor(true);
    var blade_offSet = brick_wall.setOffset(2.0, -2, -40);
    var blade_rot = brick_wall.setRotation(-90, 90, 90);
    brick_wall.anchor = blade_anchor, blade_offSet, blade_rot;
}

}