extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:hawkgirl_layer1",
    "layer2": "eden:hawkgirl_layer2",
    "wings": "eden:hawkgirl_wings",
    "mace": "eden:mace",
    "back_wings": "eden:hawkman_back_wings",
    "wings_back": "eden:hawkgirl_wings_back"
});

var utils = implement("fiskheroes:external/utils");
var wing_utils = implement("fiskheroes:external/wing_utils");

var wings;

var wings_back;

var ears;

function init(renderer) {
    parent.init(renderer);
	
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}

function initEffects(renderer) {

    ears = renderer.createEffect("fiskheroes:ears");
    ears.anchor.set("head");
    ears.angle = 20;
    ears.inset = 0.075;

	var model_mace = renderer.createResource("MODEL", "eden:mace");
    model_mace.texture.set("mace");

    wings = wing_utils.create(renderer, "wings", null, wing_utils.PRESET_CONTROLLED_FLIGHT);

    mace = renderer.createEffect("fiskheroes:model").setModel(model_mace);
    mace.anchor.set("rightArm");
    mace.setScale(0.8);

    var model_back_mace = renderer.createResource("MODEL", "eden:mace");
    model_back_mace.texture.set("mace");
    back_mace = renderer.createEffect("fiskheroes:model").setModel(model_back_mace);
    back_mace.anchor.set("body");
    back_mace.setScale(0.4);

    utils.bindBeam(renderer, "fiskheroes:energy_manipulation", "fiskheroes:energy_discharge", "rightArm", 0xedeeee, [
        { "firstPerson": [-2.5, 0.0, -7.0], "offset": [-0.5, 19.0, -12.0], "size": [1.5, 1.5] }
    ]);

    back_wings = renderer.createEffect("fiskheroes:overlay");
    back_wings.texture.set(null, "back_wings");

    wings_back = renderer.createEffect("fiskheroes:model");
    wings_back.setModel(utils.createModel(renderer, "eden:wings", "wings_back", null));
    wings_back.anchor.set("rightArm");
    wings_back.mirror = false;
    wings_back.setScale(1.2);

}

function initAnimations(renderer) {
    parent.initAnimations(renderer);
    utils.addHoverAnimation(renderer, "falcon.HOVER", "fiskheroes:flight/idle/falcon");
    utils.addFlightAnimation(renderer, "falcon.FLIGHT", getFlightAnimation(), (entity, data) => {
        data.load(0, entity.getInterpolatedData("fiskheroes:flight_timer"));
        data.load(1, entity.getInterpolatedData("fiskheroes:flight_boost_timer"));
        data.load(3, entity.getInterpolatedData("fiskheroes:dyn/flight_super_boost_timer"));
    });

    utils.addAnimationEvent(renderer, "FLIGHT_DIVE", "fiskheroes:iron_man_dive");
    utils.addAnimationEvent(renderer, "FLIGHT_DIVE_ROLL", "fiskheroes:falcon_dive_roll");

    addAnimationWithData(renderer, "falcon.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

    addAnimationWithData(renderer, "mace.SWORD_POSE", "fiskheroes:sword_pose", "fiskheroes:shield_timer");
}

function getFlightAnimation() {
    return "fiskheroes:flight/falcon.anim.json";
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        if (entity.getData("fiskheroes:blade_timer") > 0.9) {
            var blade_anchor = mace.anchor.set("rightArm");
            var blade_offSet = mace.setOffset(2.8, 6.8, 19.3);
            var blade_rot = mace.setRotation(90, 0, 0);
            

			
            mace.anchor = blade_anchor, blade_offSet, blade_rot;
            mace.render();
        }


}
if (renderLayer == "CHESTPLATE") {
    back_mace.opacity = entity.getData("fiskheroes:blade") < 1;
    back_mace.render();

    var blade_anchor = back_mace.anchor.set("body");
    var blade_offSet = back_mace.setOffset(5.3, 22.2, 11.3);
    var blade_rot = back_mace.setRotation(45, 0, 0);
    back_mace.anchor = blade_anchor, blade_offSet, blade_rot;


}
if (renderLayer == "CHESTPLATE") {
    wings.render(entity, entity.getInterpolatedData("fiskheroes:shield_blocking_timer"));

}
if (renderLayer ==  "CHESTPLATE") {
    back_wings.opacity = entity.getInterpolatedData("fiskheroes:flight_timer") < 1;
    back_wings.render();
}
if (renderLayer == "CHESTPLATE") {

    wings_back.opacity = entity.getData("fiskheroes:flight_timer") < 1;
    wings_back.render();

    var blade_anchor = wings_back.anchor.set("body");
    var blade_offSet = wings_back.setOffset(-1.0, 4.6, -0.5);
    var blade_rot = wings_back.setRotation(0, 0, 0);
    wings_back.anchor = blade_anchor, blade_offSet, blade_rot;
}
if (!isFirstPersonArm && renderLayer == "HELMET" || "CHESTPLATE") {
    ears.render();
}

}