extend("fiskheroes:hero_basic");
loadTextures({
    "layer1": "eden:hybrid_layer1",
    "layer2": "eden:hybrid_layer2",
    "wings": "eden:hybrid_wings",
    "shield": "eden:raptor_claw",
    "hybrid_form": "eden:hybrid_form",
    "tail": "eden:hybrid_tail",
    "lights": "eden:hybrid_tail",
});

var utils = implement("fiskheroes:external/utils");

var speedster = implement("fiskheroes:external/speedster_utils");

var wings;

var raptor_tail;

function init(renderer) {
    parent.init(renderer);
    renderer.showModel("CHESTPLATE", "head", "headwear", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
    renderer.fixHatLayer("CHESTPLATE");
}
function initEffects(renderer) {


    shield = renderer.createEffect("fiskheroes:shield");
    shield.texture.set("shield");
    shield.anchor.set("rightArm");
    shield.setCurve(25.0, 35.0);
    shield.mirror = true

    wings = renderer.createEffect("fiskheroes:wings");
    wings.texture.set("wings");
    wings.anchor.set("body");

    utils.bindBeam(renderer, "fiskheroes:charged_beam", "fiskheroes:energy_projection", "rightArm", 0x55FF55, [
        { "firstPerson": [-4.5, 3.75, -8.0], "offset": [-0.5, 9.0, 0.0], "size": [3.0, 3.0],"anchor": "rightArm" },
    ]).setParticles(renderer.createResource("PARTICLE_EMITTER", "fiskheroes:impact_antimatter"));

    night_vision = renderer.bindProperty("fiskheroes:night_vision");
    night_vision.factor = 0.30;
    night_vision.firstPersonOnly = false;

    hybrid_form = renderer.createEffect("fiskheroes:overlay");
    hybrid_form.texture.set(null, "hybrid_form");

    raptor_tail = renderer.createEffect("fiskheroes:model");
    raptor_tail.setModel(utils.createModel(renderer, "eden:raptor_tail", "tail", "lights"));
    raptor_tail.anchor.set("body");
    raptor_tail.mirror = false;
    
}

function initAnimations(renderer) {
    parent.initAnimations(renderer);

    utils.addHoverAnimation(renderer, "falcon.HOVER", "fiskheroes:flight/idle/falcon");
    utils.addFlightAnimation(renderer, "falcon.FLIGHT", getFlightAnimation(), (entity, data) => {
        data.load(0, entity.getInterpolatedData("fiskheroes:flight_timer"));
        data.load(1, entity.getInterpolatedData("fiskheroes:flight_boost_timer"));
        data.load(3, entity.getInterpolatedData("fiskheroes:dyn/flight_super_boost_timer"));
    });

    utils.addAnimationEvent(renderer, "FLIGHT_DIVE", "fiskheroes:iron_man_dive");
    utils.addAnimationEvent(renderer, "FLIGHT_DIVE_ROLL", "fiskheroes:falcon_dive_roll");

    addAnimationWithData(renderer, "falcon.ROLL", "fiskheroes:flight/barrel_roll", "fiskheroes:barrel_roll_timer")
        .priority = 10;

    renderer.removeCustomAnimation("basic.CHARGED_BEAM");

    addAnimationWithData(renderer, "antimonitor.ANTIBLAST", "fiskheroes:aiming", "fiskheroes:beam_charge");
}

function getFlightAnimation() {
    return "fiskheroes:flight/falcon.anim.json";
}

function render(entity, renderLayer, isFirstPersonArm) {
    if (renderLayer == "CHESTPLATE") {
        shield.unfold = entity.getInterpolatedData("fiskheroes:shield_timer");
        shield.setOffset(2.9 + 1.35 * Math.min(shield.unfold * 5, 1), 5.0, 0.0);
        shield.render();
    }
    if (entity.getData("fiskheroes:flying") > 0.6) {
        wings.render();
    } 
    if (renderLayer == "LEGGINGS" || renderLayer == "BOOTS" || renderLayer == "HELMET" || "CHESTPLATE") {
        hybrid_form.opacity = entity.getInterpolatedData("fiskheroes:dyn/giant_mode_timer");
        hybrid_form.render();
    }
    if (renderLayer == "CHESTPLATE") {
        raptor_tail.opacity = entity.getData("fiskheroes:dyn/giant_mode_timer");
        raptor_tail.render();

        var blade_anchor = raptor_tail.anchor.set("body");
        var blade_offSet = raptor_tail.setOffset(-1.4, 13.3, 3.0);
        var blade_rot = raptor_tail.setRotation(-100, 90, 0);
        raptor_tail.anchor = blade_anchor, blade_offSet, blade_rot;
    }
}